/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.handler.StreamedAsyncHandler;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.NettyResponseStatus;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.reactivestreams.Publisher;

@ChannelHandler.Sharable
public final class HttpHandler
extends AsyncHttpClientHandler {
    public HttpHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        super(config, channelManager, requestSender);
    }

    private void finishUpdate(NettyResponseFuture<?> future, Channel channel, boolean expectOtherChunks) throws IOException {
        future.cancelTimeouts();
        boolean keepAlive = future.isKeepAlive();
        if (expectOtherChunks && keepAlive) {
            this.channelManager.drainChannelAndOffer(channel, future);
        } else {
            this.channelManager.tryToOfferChannelToPool(channel, future.getAsyncHandler(), keepAlive, future.getPartitionKey());
        }
        try {
            future.done();
        }
        catch (Exception t) {
            this.logger.debug(t.getMessage(), (Throwable)t);
        }
    }

    private boolean updateBodyAndInterrupt(NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseBodyPart bodyPart) throws Exception {
        boolean interrupt;
        boolean bl = interrupt = handler.onBodyPartReceived(bodyPart) != AsyncHandler.State.CONTINUE;
        if (interrupt) {
            future.setKeepAlive(false);
        }
        return interrupt;
    }

    private void notifyHandler(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseStatus status, HttpRequest httpRequest, HttpResponseHeaders responseHeaders) throws IOException, Exception {
        boolean exit;
        boolean bl = exit = this.exitAfterHandlingStatus(channel, future, response, handler, status, httpRequest) || this.exitAfterHandlingHeaders(channel, future, response, handler, responseHeaders, httpRequest) || this.exitAfterHandlingReactiveStreams(channel, future, response, handler, httpRequest);
        if (exit) {
            this.finishUpdate(future, channel, HttpUtil.isTransferEncodingChunked((HttpMessage)httpRequest) || HttpUtil.isTransferEncodingChunked((HttpMessage)response));
        }
    }

    private boolean exitAfterHandlingStatus(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseStatus status, HttpRequest httpRequest) throws IOException, Exception {
        return !future.isAndSetStatusReceived(true) && handler.onStatusReceived(status) != AsyncHandler.State.CONTINUE;
    }

    private boolean exitAfterHandlingHeaders(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, HttpResponseHeaders responseHeaders, HttpRequest httpRequest) throws IOException, Exception {
        return !response.headers().isEmpty() && handler.onHeadersReceived(responseHeaders) != AsyncHandler.State.CONTINUE;
    }

    private boolean exitAfterHandlingReactiveStreams(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, HttpRequest httpRequest) throws IOException {
        if (handler instanceof StreamedAsyncHandler) {
            StreamedAsyncHandler streamedAsyncHandler = (StreamedAsyncHandler)handler;
            StreamedResponsePublisher publisher = new StreamedResponsePublisher((EventExecutor)channel.eventLoop(), this.channelManager, future, channel);
            channel.pipeline().addLast((EventExecutorGroup)channel.eventLoop(), "streamedAsyncHandler", (ChannelHandler)publisher);
            Channels.setAttribute(channel, (Object)publisher);
            return streamedAsyncHandler.onStream((Publisher<HttpResponseBodyPart>)publisher) != AsyncHandler.State.CONTINUE;
        }
        return false;
    }

    private void handleHttpResponse(HttpResponse response, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
        this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
        future.setKeepAlive(this.config.getKeepAliveStrategy().keepAlive(future.getTargetRequest(), httpRequest, response));
        NettyResponseStatus status = new NettyResponseStatus(future.getUri(), this.config, response, channel);
        HttpResponseHeaders responseHeaders = new HttpResponseHeaders(response.headers());
        if (!this.interceptors.exitAfterIntercept(channel, future, handler, response, status, responseHeaders)) {
            this.notifyHandler(channel, future, response, handler, status, httpRequest, responseHeaders);
        }
    }

    private void handleChunk(HttpContent chunk, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws IOException, Exception {
        LastHttpContent lastChunk;
        HttpHeaders trailingHeaders;
        boolean interrupt = false;
        boolean last = chunk instanceof LastHttpContent;
        if (last && !(trailingHeaders = (lastChunk = (LastHttpContent)chunk).trailingHeaders()).isEmpty()) {
            interrupt = handler.onHeadersReceived(new HttpResponseHeaders(trailingHeaders, true)) != AsyncHandler.State.CONTINUE;
        }
        ByteBuf buf = chunk.content();
        if (!(interrupt || handler instanceof StreamedAsyncHandler || buf.readableBytes() <= 0 && !last)) {
            HttpResponseBodyPart part = this.config.getResponseBodyPartFactory().newResponseBodyPart(buf, last);
            interrupt = this.updateBodyAndInterrupt(future, handler, part);
        }
        if (interrupt || last) {
            this.finishUpdate(future, channel, !last);
        }
    }

    @Override
    public void handleRead(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        if (future.isDone()) {
            this.channelManager.closeChannel(channel);
            return;
        }
        AsyncHandler<?> handler = future.getAsyncHandler();
        try {
            HttpObject object;
            Throwable t;
            if (e instanceof HttpObject && (t = (object = (HttpObject)e).decoderResult().cause()) != null) {
                this.readFailed(channel, future, t);
                return;
            }
            if (e instanceof HttpResponse) {
                this.handleHttpResponse((HttpResponse)e, channel, future, handler);
            } else if (e instanceof HttpContent) {
                this.handleChunk((HttpContent)e, channel, future, handler);
            }
        }
        catch (Exception t) {
            if (this.hasIOExceptionFilters && t instanceof IOException && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, (IOException)IOException.class.cast(t), channel)) {
                return;
            }
            this.readFailed(channel, future, t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFailed(Channel channel, NettyResponseFuture<?> future, Throwable t) throws Exception {
        try {
            this.requestSender.abort(channel, future, t);
        }
        catch (Exception abortException) {
            this.logger.debug("Abort failed", (Throwable)abortException);
        }
        finally {
            this.finishUpdate(future, channel, false);
        }
    }

    @Override
    public void handleException(NettyResponseFuture<?> future, Throwable error) {
    }

    @Override
    public void handleChannelInactive(NettyResponseFuture<?> future) {
    }
}

