/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.NettyResponseStatus;
import org.asynchttpclient.netty.OnLastHttpContentCallback;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.ws.NettyWebSocket;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.asynchttpclient.ws.WebSocketUtils;

@ChannelHandler.Sharable
public final class WebSocketHandler
extends AsyncHttpClientHandler {
    public WebSocketHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        super(config, channelManager, requestSender);
    }

    @Override
    public void handleRead(final Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        if (e instanceof HttpResponse) {
            HttpResponseHeaders responseHeaders;
            NettyResponseStatus status;
            WebSocketUpgradeHandler handler;
            HttpResponse response = (HttpResponse)e;
            if (this.logger.isDebugEnabled()) {
                HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
                this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
            }
            if (!this.interceptors.exitAfterIntercept(channel, future, handler = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(future.getAsyncHandler()), response, status = new NettyResponseStatus(future.getUri(), this.config, response, channel), responseHeaders = new HttpResponseHeaders(response.headers()))) {
                Channels.setAttribute(channel, new UpgradeCallback(future, channel, response, handler, status, responseHeaders));
            }
        } else if (e instanceof WebSocketFrame) {
            final WebSocketFrame frame = (WebSocketFrame)e;
            final WebSocketUpgradeHandler handler = (WebSocketUpgradeHandler)future.getAsyncHandler();
            NettyWebSocket webSocket = (NettyWebSocket)handler.onCompleted();
            if (webSocket != null) {
                this.handleFrame(channel, frame, handler, webSocket);
            } else {
                this.logger.debug("Frame received but WebSocket is not available yet, buffering frame");
                frame.retain();
                Runnable bufferedFrame = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            NettyWebSocket webSocket = (NettyWebSocket)handler.onCompleted();
                            WebSocketHandler.this.handleFrame(channel, frame, handler, webSocket);
                        }
                        catch (Exception e) {
                            WebSocketHandler.this.logger.debug("Failure while handling buffered frame", (Throwable)e);
                            handler.onFailure(e);
                        }
                        finally {
                            frame.release();
                        }
                    }
                };
                handler.bufferFrame(bufferedFrame);
            }
        } else {
            this.logger.error("Invalid message {}", e);
        }
    }

    private void handleFrame(Channel channel, WebSocketFrame frame, WebSocketUpgradeHandler handler, NettyWebSocket webSocket) throws Exception {
        if (frame instanceof TextWebSocketFrame) {
            webSocket.onTextFrame((TextWebSocketFrame)frame);
        } else if (frame instanceof BinaryWebSocketFrame) {
            webSocket.onBinaryFrame((BinaryWebSocketFrame)frame);
        } else if (frame instanceof CloseWebSocketFrame) {
            Channels.setDiscard(channel);
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            webSocket.onClose(closeFrame.statusCode(), closeFrame.reasonText());
            Channels.silentlyCloseChannel(channel);
        } else if (frame instanceof PingWebSocketFrame) {
            webSocket.onPing((PingWebSocketFrame)frame);
        } else if (frame instanceof PongWebSocketFrame) {
            webSocket.onPong((PongWebSocketFrame)frame);
        }
    }

    @Override
    public void handleException(NettyResponseFuture<?> future, Throwable e) {
        this.logger.warn("onError", e);
        try {
            WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)future.getAsyncHandler();
            NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
            if (webSocket != null) {
                webSocket.onError(e.getCause());
                webSocket.close();
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }

    @Override
    public void handleChannelInactive(NettyResponseFuture<?> future) {
        this.logger.trace("onClose");
        try {
            WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)future.getAsyncHandler();
            NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
            this.logger.trace("Connection was closed abnormally (that is, with no close frame being received).");
            if (webSocket != null) {
                webSocket.close(1006, "Connection was closed abnormally (that is, with no close frame being received).");
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }

    private class UpgradeCallback
    extends OnLastHttpContentCallback {
        private final Channel channel;
        private final HttpResponse response;
        private final WebSocketUpgradeHandler handler;
        private final HttpResponseStatus status;
        private final HttpResponseHeaders responseHeaders;

        public UpgradeCallback(NettyResponseFuture<?> future, Channel channel, HttpResponse response, WebSocketUpgradeHandler handler, HttpResponseStatus status, HttpResponseHeaders responseHeaders) {
            super(future);
            this.channel = channel;
            this.response = response;
            this.handler = handler;
            this.status = status;
            this.responseHeaders = responseHeaders;
        }

        private void invokeOnSucces(Channel channel, WebSocketUpgradeHandler h) {
            if (!h.touchSuccess()) {
                try {
                    h.onSuccess(new NettyWebSocket(channel, this.responseHeaders.getHeaders()));
                }
                catch (Exception ex) {
                    WebSocketHandler.this.logger.warn("onSuccess unexpected exception", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call() throws Exception {
            boolean headerOK;
            boolean statusReceived;
            boolean validStatus = this.response.status().equals((Object)io.netty.handler.codec.http.HttpResponseStatus.SWITCHING_PROTOCOLS);
            boolean validUpgrade = this.response.headers().get((CharSequence)HttpHeaderNames.UPGRADE) != null;
            String connection = this.response.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
            if (connection == null) {
                connection = this.response.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
            }
            boolean validConnection = HttpHeaderValues.UPGRADE.contentEqualsIgnoreCase((CharSequence)connection);
            boolean bl = statusReceived = this.handler.onStatusReceived(this.status) == AsyncHandler.State.UPGRADE;
            if (!statusReceived) {
                try {
                    this.handler.onCompleted();
                }
                finally {
                    this.future.done();
                }
                return;
            }
            boolean bl2 = headerOK = this.handler.onHeadersReceived(this.responseHeaders) == AsyncHandler.State.CONTINUE;
            if (!(headerOK && validStatus && validUpgrade && validConnection)) {
                WebSocketHandler.this.requestSender.abort(this.channel, this.future, new IOException("Invalid handshake response"));
                return;
            }
            String accept = this.response.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
            String key = WebSocketUtils.getAcceptKey(this.future.getNettyRequest().getHttpRequest().headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY));
            if (accept == null || !accept.equals(key)) {
                WebSocketHandler.this.requestSender.abort(this.channel, this.future, new IOException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, key)));
            }
            Channels.setAttribute(this.channel, this.future);
            WebSocketHandler.this.channelManager.upgradePipelineForWebSockets(this.channel.pipeline());
            this.invokeOnSucces(this.channel, this.handler);
            this.future.done();
        }
    }
}

