/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import io.netty.handler.codec.http.HttpHeaders;
import java.util.ArrayList;
import java.util.List;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.netty.ws.NettyWebSocket;
import org.asynchttpclient.ws.WebSocketListener;

public class WebSocketUpgradeHandler
implements AsyncHandler<NettyWebSocket> {
    private static final int SWITCHING_PROTOCOLS = io.netty.handler.codec.http.HttpResponseStatus.SWITCHING_PROTOCOLS.code();
    private NettyWebSocket webSocket;
    private final List<WebSocketListener> listeners;

    public WebSocketUpgradeHandler(List<WebSocketListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public final AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        return responseStatus.getStatusCode() == SWITCHING_PROTOCOLS ? AsyncHandler.State.CONTINUE : AsyncHandler.State.ABORT;
    }

    @Override
    public final AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final NettyWebSocket onCompleted() throws Exception {
        return this.webSocket;
    }

    @Override
    public final void onThrowable(Throwable t) {
        for (WebSocketListener listener : this.listeners) {
            if (this.webSocket != null) {
                this.webSocket.addWebSocketListener(listener);
            }
            listener.onError(t);
        }
    }

    public final void setWebSocket(NettyWebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public final void onOpen() {
        for (WebSocketListener listener : this.listeners) {
            this.webSocket.addWebSocketListener(listener);
            listener.onOpen(this.webSocket);
        }
        this.webSocket.processBufferedFrames();
    }

    public static final class Builder {
        private List<WebSocketListener> listeners = new ArrayList<WebSocketListener>(1);

        public Builder addWebSocketListener(WebSocketListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder removeWebSocketListener(WebSocketListener listener) {
            this.listeners.remove(listener);
            return this;
        }

        public WebSocketUpgradeHandler build() {
            return new WebSocketUpgradeHandler(this.listeners);
        }
    }
}

