/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.ClientStats;
import org.asynchttpclient.HostStats;
import org.asynchttpclient.SslEngineFactory;
import org.asynchttpclient.channel.ChannelPool;
import org.asynchttpclient.channel.ChannelPoolPartitioning;
import org.asynchttpclient.channel.NoopChannelPool;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.AsyncHandlerExtensionsUtils;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.OnLastHttpContentCallback;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.DefaultChannelPool;
import org.asynchttpclient.netty.channel.NioSocketChannelFactory;
import org.asynchttpclient.netty.channel.NoopHandler;
import org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import org.asynchttpclient.netty.handler.HttpHandler;
import org.asynchttpclient.netty.handler.WebSocketHandler;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.ssl.DefaultSslEngineFactory;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    public static final String PINNED_ENTRY = "entry";
    public static final String HTTP_CLIENT_CODEC = "http";
    public static final String SSL_HANDLER = "ssl";
    public static final String DEFLATER_HANDLER = "deflater";
    public static final String INFLATER_HANDLER = "inflater";
    public static final String CHUNKED_WRITER_HANDLER = "chunked-writer";
    public static final String WS_DECODER_HANDLER = "ws-decoder";
    public static final String WS_FRAME_AGGREGATOR = "ws-aggregator";
    public static final String WS_ENCODER_HANDLER = "ws-encoder";
    public static final String AHC_HTTP_HANDLER = "ahc-http";
    public static final String AHC_WS_HANDLER = "ahc-ws";
    public static final String LOGGING_HANDLER = "logging";
    private final AsyncHttpClientConfig config;
    private final SslEngineFactory sslEngineFactory;
    private final EventLoopGroup eventLoopGroup;
    private final boolean allowReleaseEventLoopGroup;
    private final Bootstrap httpBootstrap;
    private final Bootstrap wsBootstrap;
    private final long handshakeTimeout;
    private final ChannelPool channelPool;
    private final ChannelGroup openChannels;
    private AsyncHttpClientHandler wsHandler;

    public ChannelManager(AsyncHttpClientConfig config, Timer nettyTimer) {
        NioSocketChannelFactory channelFactory;
        this.config = config;
        this.sslEngineFactory = config.getSslEngineFactory() != null ? config.getSslEngineFactory() : new DefaultSslEngineFactory();
        try {
            this.sslEngineFactory.init(config);
        }
        catch (SSLException e) {
            throw new RuntimeException("Could not initialize sslEngineFactory", e);
        }
        ChannelPool channelPool = config.getChannelPool();
        if (channelPool == null) {
            channelPool = config.isKeepAlive() ? new DefaultChannelPool(config, nettyTimer) : NoopChannelPool.INSTANCE;
        }
        this.channelPool = channelPool;
        this.openChannels = new DefaultChannelGroup("asyncHttpClient", (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.handshakeTimeout = config.getHandshakeTimeout();
        ThreadFactory threadFactory = config.getThreadFactory() != null ? config.getThreadFactory() : new DefaultThreadFactory(config.getThreadPoolName());
        boolean bl = this.allowReleaseEventLoopGroup = config.getEventLoopGroup() == null;
        if (this.allowReleaseEventLoopGroup) {
            if (config.isUseNativeTransport()) {
                this.eventLoopGroup = this.newEpollEventLoopGroup(config.getIoThreadsCount(), threadFactory);
                channelFactory = this.getEpollSocketChannelFactory();
            } else {
                this.eventLoopGroup = new NioEventLoopGroup(config.getIoThreadsCount(), threadFactory);
                channelFactory = NioSocketChannelFactory.INSTANCE;
            }
        } else {
            this.eventLoopGroup = config.getEventLoopGroup();
            if (this.eventLoopGroup instanceof OioEventLoopGroup) {
                throw new IllegalArgumentException("Oio is not supported");
            }
            channelFactory = this.eventLoopGroup instanceof NioEventLoopGroup ? NioSocketChannelFactory.INSTANCE : this.getEpollSocketChannelFactory();
        }
        this.httpBootstrap = this.newBootstrap(channelFactory, this.eventLoopGroup, config);
        this.wsBootstrap = this.newBootstrap(channelFactory, this.eventLoopGroup, config);
        this.httpBootstrap.option(ChannelOption.AUTO_READ, (Object)false);
    }

    private Bootstrap newBootstrap(ChannelFactory<? extends Channel> channelFactory, EventLoopGroup eventLoopGroup, AsyncHttpClientConfig config) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(channelFactory)).group(eventLoopGroup)).option(ChannelOption.ALLOCATOR, (Object)(config.getAllocator() != null ? config.getAllocator() : ByteBufAllocator.DEFAULT))).option(ChannelOption.TCP_NODELAY, (Object)config.isTcpNoDelay())).option(ChannelOption.SO_REUSEADDR, (Object)config.isSoReuseAddress())).option(ChannelOption.AUTO_CLOSE, (Object)false);
        if (config.getConnectTimeout() > 0) {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout());
        }
        if (config.getSoLinger() >= 0) {
            bootstrap.option(ChannelOption.SO_LINGER, (Object)config.getSoLinger());
        }
        if (config.getSoSndBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)config.getSoSndBuf());
        }
        if (config.getSoRcvBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)config.getSoRcvBuf());
        }
        for (Map.Entry<ChannelOption<Object>, Object> entry : config.getChannelOptions().entrySet()) {
            bootstrap.option(entry.getKey(), entry.getValue());
        }
        return bootstrap;
    }

    private EventLoopGroup newEpollEventLoopGroup(int ioThreadsCount, ThreadFactory threadFactory) {
        try {
            Class<?> epollEventLoopGroupClass = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup");
            return (EventLoopGroup)epollEventLoopGroupClass.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(ioThreadsCount, threadFactory);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ChannelFactory<? extends Channel> getEpollSocketChannelFactory() {
        try {
            return (ChannelFactory)Class.forName("org.asynchttpclient.netty.channel.EpollSocketChannelFactory").newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureBootstraps(NettyRequestSender requestSender) {
        final HttpHandler httpHandler = new HttpHandler(this.config, this, requestSender);
        this.wsHandler = new WebSocketHandler(this.config, this, requestSender);
        final NoopHandler pinnedEntry = new NoopHandler();
        final LoggingHandler loggingHandler = new LoggingHandler(LogLevel.TRACE);
        this.httpBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.PINNED_ENTRY, (ChannelHandler)pinnedEntry).addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.INFLATER_HANDLER, (ChannelHandler)ChannelManager.this.newHttpContentDecompressor()).addLast(ChannelManager.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler()).addLast(ChannelManager.AHC_HTTP_HANDLER, (ChannelHandler)httpHandler);
                if (LOGGER.isTraceEnabled()) {
                    pipeline.addAfter(ChannelManager.PINNED_ENTRY, ChannelManager.LOGGING_HANDLER, (ChannelHandler)loggingHandler);
                }
                if (ChannelManager.this.config.getHttpAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getHttpAdditionalChannelInitializer().initChannel(ch);
                }
            }
        });
        this.wsBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.PINNED_ENTRY, (ChannelHandler)pinnedEntry).addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.AHC_WS_HANDLER, (ChannelHandler)ChannelManager.this.wsHandler);
                if (LOGGER.isDebugEnabled()) {
                    pipeline.addAfter(ChannelManager.PINNED_ENTRY, ChannelManager.LOGGING_HANDLER, (ChannelHandler)loggingHandler);
                }
                if (ChannelManager.this.config.getWsAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getWsAdditionalChannelInitializer().initChannel(ch);
                }
            }
        });
    }

    private HttpContentDecompressor newHttpContentDecompressor() {
        if (this.config.isKeepEncodingHeader()) {
            return new HttpContentDecompressor(){

                protected String getTargetContentEncoding(String contentEncoding) throws Exception {
                    return contentEncoding;
                }
            };
        }
        return new HttpContentDecompressor();
    }

    public final void tryToOfferChannelToPool(Channel channel, AsyncHandler<?> asyncHandler, boolean keepAlive, Object partitionKey) {
        if (channel.isActive() && keepAlive) {
            LOGGER.debug("Adding key: {} for channel {}", partitionKey, (Object)channel);
            Channels.setDiscard(channel);
            AsyncHandlerExtensions asyncHandlerExtensions = AsyncHandlerExtensionsUtils.toAsyncHandlerExtensions(asyncHandler);
            if (asyncHandlerExtensions != null) {
                try {
                    asyncHandlerExtensions.onConnectionOffer(channel);
                }
                catch (Exception e) {
                    LOGGER.error("onConnectionOffer crashed", (Throwable)e);
                }
            }
            if (!this.channelPool.offer(channel, partitionKey)) {
                this.closeChannel(channel);
            }
        } else {
            this.closeChannel(channel);
        }
    }

    public Channel poll(Uri uri, String virtualHost, ProxyServer proxy, ChannelPoolPartitioning connectionPoolPartitioning) {
        Object partitionKey = connectionPoolPartitioning.getPartitionKey(uri, virtualHost, proxy);
        return this.channelPool.poll(partitionKey);
    }

    public boolean removeAll(Channel connection) {
        return this.channelPool.removeAll(connection);
    }

    private void doClose() {
        this.openChannels.close();
        this.channelPool.destroy();
    }

    public void close() {
        if (this.allowReleaseEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully((long)this.config.getShutdownQuietPeriod(), (long)this.config.getShutdownTimeout(), TimeUnit.MILLISECONDS).addListener(future -> this.doClose());
        } else {
            this.doClose();
        }
    }

    public void closeChannel(Channel channel) {
        LOGGER.debug("Closing Channel {} ", (Object)channel);
        Channels.setDiscard(channel);
        this.removeAll(channel);
        Channels.silentlyCloseChannel(channel);
    }

    public void registerOpenChannel(Channel channel, Object partitionKey) {
        this.openChannels.add((Object)channel);
    }

    private HttpClientCodec newHttpClientCodec() {
        return new HttpClientCodec(this.config.getHttpClientCodecMaxInitialLineLength(), this.config.getHttpClientCodecMaxHeaderSize(), this.config.getHttpClientCodecMaxChunkSize(), false, this.config.isValidateResponseHeaders(), this.config.getHttpClientCodecInitialBufferSize());
    }

    private SslHandler createSslHandler(String peerHost, int peerPort) {
        SSLEngine sslEngine = this.sslEngineFactory.newSslEngine(this.config, peerHost, peerPort);
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (this.handshakeTimeout > 0L) {
            sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeout);
        }
        return sslHandler;
    }

    public static boolean isSslHandlerConfigured(ChannelPipeline pipeline) {
        return pipeline.get(SSL_HANDLER) != null;
    }

    public void upgradeProtocol(ChannelPipeline pipeline, Uri requestUri) throws SSLException {
        if (pipeline.get(HTTP_CLIENT_CODEC) != null) {
            pipeline.remove(HTTP_CLIENT_CODEC);
        }
        if (requestUri.isSecured()) {
            if (ChannelManager.isSslHandlerConfigured(pipeline)) {
                pipeline.addAfter(SSL_HANDLER, HTTP_CLIENT_CODEC, (ChannelHandler)this.newHttpClientCodec());
            } else {
                pipeline.addAfter(PINNED_ENTRY, HTTP_CLIENT_CODEC, (ChannelHandler)this.newHttpClientCodec());
                pipeline.addAfter(PINNED_ENTRY, SSL_HANDLER, (ChannelHandler)this.createSslHandler(requestUri.getHost(), requestUri.getExplicitPort()));
            }
        } else {
            pipeline.addAfter(PINNED_ENTRY, HTTP_CLIENT_CODEC, (ChannelHandler)this.newHttpClientCodec());
        }
        if (requestUri.isWebSocket()) {
            pipeline.addAfter(AHC_HTTP_HANDLER, AHC_WS_HANDLER, (ChannelHandler)this.wsHandler);
            pipeline.remove(AHC_HTTP_HANDLER);
        }
    }

    public SslHandler addSslHandler(ChannelPipeline pipeline, Uri uri, String virtualHost) {
        int peerPort;
        String peerHost;
        if (virtualHost != null) {
            int i = virtualHost.indexOf(58);
            if (i == -1) {
                peerHost = virtualHost;
                peerPort = uri.getSchemeDefaultPort();
            } else {
                peerHost = virtualHost.substring(0, i);
                peerPort = Integer.valueOf(virtualHost.substring(i + 1));
            }
        } else {
            peerHost = uri.getHost();
            peerPort = uri.getExplicitPort();
        }
        SslHandler sslHandler = this.createSslHandler(peerHost, peerPort);
        pipeline.addFirst(SSL_HANDLER, (ChannelHandler)sslHandler);
        return sslHandler;
    }

    public Bootstrap getBootstrap(Uri uri, ProxyServer proxy) {
        return uri.isWebSocket() && proxy == null ? this.wsBootstrap : this.httpBootstrap;
    }

    public void upgradePipelineForWebSockets(ChannelPipeline pipeline) {
        pipeline.addAfter(HTTP_CLIENT_CODEC, WS_ENCODER_HANDLER, (ChannelHandler)new WebSocket08FrameEncoder(true));
        pipeline.addBefore(AHC_WS_HANDLER, WS_DECODER_HANDLER, (ChannelHandler)new WebSocket08FrameDecoder(false, false, this.config.getWebSocketMaxFrameSize()));
        if (this.config.isAggregateWebSocketFrameFragments()) {
            pipeline.addAfter(WS_DECODER_HANDLER, WS_FRAME_AGGREGATOR, (ChannelHandler)new WebSocketFrameAggregator(this.config.getWebSocketMaxBufferSize()));
        }
        pipeline.remove(HTTP_CLIENT_CODEC);
    }

    public final OnLastHttpContentCallback newDrainCallback(NettyResponseFuture<?> future, final Channel channel, final boolean keepAlive, final Object partitionKey) {
        return new OnLastHttpContentCallback(future){

            @Override
            public void call() {
                ChannelManager.this.tryToOfferChannelToPool(channel, this.future.getAsyncHandler(), keepAlive, partitionKey);
            }
        };
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future) {
        this.drainChannelAndOffer(channel, future, future.isKeepAlive(), future.getPartitionKey());
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future, boolean keepAlive, Object partitionKey) {
        Channels.setAttribute(channel, this.newDrainCallback(future, channel, keepAlive, partitionKey));
    }

    public ChannelPool getChannelPool() {
        return this.channelPool;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public ClientStats getClientStats() {
        Map totalConnectionsPerHost = this.openChannels.stream().map(Channel::remoteAddress).filter(a -> a.getClass() == InetSocketAddress.class).map(a -> (InetSocketAddress)a).map(InetSocketAddress::getHostName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map<String, Long> idleConnectionsPerHost = this.channelPool.getIdleChannelCountPerHost();
        Map<String, HostStats> statsPerHost = totalConnectionsPerHost.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            long totalConnectionCount = (Long)entry.getValue();
            long idleConnectionCount = idleConnectionsPerHost.getOrDefault(entry.getKey(), 0L);
            long activeConnectionCount = totalConnectionCount - idleConnectionCount;
            return new HostStats(activeConnectionCount, idleConnectionCount);
        }));
        return new ClientStats(statsPerHost);
    }

    public boolean isOpen() {
        return this.channelPool.isOpen();
    }
}

