/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.netty.DiscardEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channels {
    private static final Logger LOGGER = LoggerFactory.getLogger(Channels.class);
    private static final AttributeKey<Object> DEFAULT_ATTRIBUTE = AttributeKey.valueOf((String)"default");
    private static final AttributeKey<AtomicBoolean> INACTIVE_TOKEN_ATTRIBUTE = AttributeKey.valueOf((String)"inactiveToken");

    public static Object getAttribute(Channel channel) {
        Attribute attr = channel.attr(DEFAULT_ATTRIBUTE);
        return attr != null ? attr.get() : null;
    }

    public static void setAttribute(Channel channel, Object o) {
        channel.attr(DEFAULT_ATTRIBUTE).set(o);
    }

    public static void setDiscard(Channel channel) {
        Channels.setAttribute(channel, (Object)DiscardEvent.INSTANCE);
    }

    public static boolean isChannelValid(Channel channel) {
        return channel != null && channel.isActive();
    }

    public static void setInactiveToken(Channel channel) {
        channel.attr(INACTIVE_TOKEN_ATTRIBUTE).set((Object)new AtomicBoolean(true));
    }

    public static boolean getInactiveToken(Channel channel) {
        return channel != null && ((AtomicBoolean)channel.attr(INACTIVE_TOKEN_ATTRIBUTE).get()).getAndSet(false);
    }

    public static void silentlyCloseChannel(Channel channel) {
        try {
            if (channel != null && channel.isActive()) {
                channel.close();
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Failed to close channel", t);
        }
    }
}

