/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.handler.StreamedAsyncHandler;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.NettyResponseStatus;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.reactivestreams.Publisher;

@ChannelHandler.Sharable
public final class HttpHandler
extends AsyncHttpClientHandler {
    public HttpHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        super(config, channelManager, requestSender);
    }

    private boolean abortAfterHandlingStatus(AsyncHandler<?> handler, NettyResponseStatus status) throws IOException, Exception {
        return handler.onStatusReceived(status) == AsyncHandler.State.ABORT;
    }

    private boolean abortAfterHandlingHeaders(AsyncHandler<?> handler, HttpResponseHeaders responseHeaders) throws IOException, Exception {
        return !responseHeaders.getHeaders().isEmpty() && handler.onHeadersReceived(responseHeaders) == AsyncHandler.State.ABORT;
    }

    private boolean abortAfterHandlingReactiveStreams(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws IOException {
        if (handler instanceof StreamedAsyncHandler) {
            StreamedAsyncHandler streamedAsyncHandler = (StreamedAsyncHandler)handler;
            StreamedResponsePublisher publisher = new StreamedResponsePublisher((EventExecutor)channel.eventLoop(), this.channelManager, future, channel);
            channel.pipeline().addLast((EventExecutorGroup)channel.eventLoop(), "streamedAsyncHandler", (ChannelHandler)publisher);
            Channels.setAttribute(channel, (Object)publisher);
            return streamedAsyncHandler.onStream((Publisher<HttpResponseBodyPart>)publisher) == AsyncHandler.State.ABORT;
        }
        return false;
    }

    private void handleHttpResponse(HttpResponse response, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
        this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
        future.setKeepAlive(this.config.getKeepAliveStrategy().keepAlive(future.getTargetRequest(), httpRequest, response));
        NettyResponseStatus status = new NettyResponseStatus(future.getUri(), response, channel);
        HttpResponseHeaders responseHeaders = new HttpResponseHeaders(response.headers());
        if (!this.interceptors.exitAfterIntercept(channel, future, handler, response, status, responseHeaders)) {
            boolean abort;
            boolean bl = abort = this.abortAfterHandlingStatus(handler, status) || this.abortAfterHandlingHeaders(handler, responseHeaders) || this.abortAfterHandlingReactiveStreams(channel, future, handler);
            if (abort) {
                this.finishUpdate(future, channel, false, false);
            }
        }
    }

    private void handleChunk(HttpContent chunk, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws IOException, Exception {
        LastHttpContent lastChunk;
        HttpHeaders trailingHeaders;
        boolean abort = false;
        boolean last = chunk instanceof LastHttpContent;
        if (last && !(trailingHeaders = (lastChunk = (LastHttpContent)chunk).trailingHeaders()).isEmpty()) {
            abort = handler.onHeadersReceived(new HttpResponseHeaders(trailingHeaders, true)) == AsyncHandler.State.ABORT;
        }
        ByteBuf buf = chunk.content();
        if (!(abort || handler instanceof StreamedAsyncHandler || buf.readableBytes() <= 0 && !last)) {
            HttpResponseBodyPart bodyPart = this.config.getResponseBodyPartFactory().newResponseBodyPart(buf, last);
            boolean bl = abort = handler.onBodyPartReceived(bodyPart) == AsyncHandler.State.ABORT;
        }
        if (abort || last) {
            boolean keepAlive = !abort && future.isKeepAlive();
            this.finishUpdate(future, channel, keepAlive, !last);
        }
    }

    @Override
    public void handleRead(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        if (future.isDone()) {
            this.channelManager.closeChannel(channel);
            return;
        }
        AsyncHandler<?> handler = future.getAsyncHandler();
        try {
            HttpObject object;
            Throwable t;
            if (e instanceof HttpObject && (t = (object = (HttpObject)e).decoderResult().cause()) != null) {
                this.readFailed(channel, future, t);
                return;
            }
            if (e instanceof HttpResponse) {
                this.handleHttpResponse((HttpResponse)e, channel, future, handler);
            } else if (e instanceof HttpContent) {
                this.handleChunk((HttpContent)e, channel, future, handler);
            }
        }
        catch (Exception t) {
            if (this.hasIOExceptionFilters && t instanceof IOException && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, (IOException)IOException.class.cast(t), channel)) {
                return;
            }
            this.readFailed(channel, future, t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFailed(Channel channel, NettyResponseFuture<?> future, Throwable t) throws Exception {
        try {
            this.requestSender.abort(channel, future, t);
        }
        catch (Exception abortException) {
            this.logger.debug("Abort failed", (Throwable)abortException);
        }
        finally {
            this.finishUpdate(future, channel, false, false);
        }
    }

    @Override
    public void handleException(NettyResponseFuture<?> future, Throwable error) {
    }

    @Override
    public void handleChannelInactive(NettyResponseFuture<?> future) {
    }
}

