/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.ws;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.util.ByteBufUtils;
import org.asynchttpclient.netty.util.Utf8ByteBufCharsetDecoder;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketByteListener;
import org.asynchttpclient.ws.WebSocketCloseCodeReasonListener;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketPingListener;
import org.asynchttpclient.ws.WebSocketPongListener;
import org.asynchttpclient.ws.WebSocketTextListener;
import org.asynchttpclient.ws.WebSocketWriteCompleteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
implements WebSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyWebSocket.class);
    protected final Channel channel;
    protected final HttpHeaders upgradeHeaders;
    protected final Collection<WebSocketListener> listeners;
    private volatile boolean interestedInByteMessages;
    private volatile boolean interestedInTextMessages;
    private boolean ready;
    private List<WebSocketFrame> bufferedFrames;

    public NettyWebSocket(Channel channel, HttpHeaders upgradeHeaders) {
        this(channel, upgradeHeaders, new ConcurrentLinkedQueue<WebSocketListener>());
    }

    public NettyWebSocket(Channel channel, HttpHeaders upgradeHeaders, Collection<WebSocketListener> listeners) {
        this.channel = channel;
        this.upgradeHeaders = upgradeHeaders;
        this.listeners = listeners;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void bufferFrame(WebSocketFrame frame) {
        if (this.bufferedFrames == null) {
            this.bufferedFrames = new ArrayList<WebSocketFrame>(1);
        }
        frame.retain();
        this.bufferedFrames.add(frame);
    }

    private void releaseBufferedFrames() {
        if (this.bufferedFrames != null) {
            for (WebSocketFrame frame : this.bufferedFrames) {
                frame.release();
            }
        }
    }

    public void processBufferedFrames() {
        this.ready = true;
        if (this.bufferedFrames != null) {
            try {
                for (WebSocketFrame frame : this.bufferedFrames) {
                    this.handleFrame(frame);
                }
            }
            finally {
                this.releaseBufferedFrames();
            }
            this.bufferedFrames = null;
        }
    }

    public void handleFrame(WebSocketFrame frame) {
        if (frame instanceof TextWebSocketFrame) {
            this.onTextFrame((TextWebSocketFrame)frame);
        } else if (frame instanceof BinaryWebSocketFrame) {
            this.onBinaryFrame((BinaryWebSocketFrame)frame);
        } else if (frame instanceof CloseWebSocketFrame) {
            Channels.setDiscard(this.channel);
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            this.onClose(closeFrame.statusCode(), closeFrame.reasonText());
            Channels.silentlyCloseChannel(this.channel);
        } else if (frame instanceof PingWebSocketFrame) {
            this.onPing((PingWebSocketFrame)frame);
        } else if (frame instanceof PongWebSocketFrame) {
            this.onPong((PongWebSocketFrame)frame);
        }
    }

    @Override
    public HttpHeaders getUpgradeHeaders() {
        return this.upgradeHeaders;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.localAddress();
    }

    @Override
    public WebSocket sendMessage(byte[] message) {
        this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])message)), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket sendMessage(byte[] message, WebSocketWriteCompleteListener listener) {
        ChannelPromise channelPromise = this.channel.newPromise();
        channelPromise.addListener((GenericFutureListener)listener);
        this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])message)), channelPromise);
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, boolean last) {
        this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(last, 0, Unpooled.wrappedBuffer((byte[])fragment)), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, boolean last, WebSocketWriteCompleteListener listener) {
        ChannelPromise channelPromise = this.channel.newPromise();
        channelPromise.addListener((GenericFutureListener)listener);
        this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(last, 0, Unpooled.wrappedBuffer((byte[])fragment)), channelPromise);
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
        this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(last, 0, Unpooled.wrappedBuffer((byte[])fragment, (int)offset, (int)len)), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, int offset, int len, boolean last, WebSocketWriteCompleteListener listener) {
        ChannelPromise channelPromise = this.channel.newPromise();
        channelPromise.addListener((GenericFutureListener)listener);
        this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(last, 0, Unpooled.wrappedBuffer((byte[])fragment, (int)offset, (int)len)), channelPromise);
        return this;
    }

    @Override
    public WebSocket sendMessage(String message) {
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(message), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket sendMessage(String message, WebSocketWriteCompleteListener listener) {
        ChannelPromise channelPromise = this.channel.newPromise();
        channelPromise.addListener((GenericFutureListener)listener);
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(message), channelPromise);
        return this;
    }

    @Override
    public WebSocket stream(String fragment, boolean last) {
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(last, 0, fragment), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket stream(String fragment, boolean last, WebSocketWriteCompleteListener listener) {
        ChannelPromise channelPromise = this.channel.newPromise();
        channelPromise.addListener((GenericFutureListener)listener);
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(last, 0, fragment), channelPromise);
        return this;
    }

    @Override
    public WebSocket sendPing(byte[] payload) {
        this.channel.writeAndFlush((Object)new PingWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload)), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket sendPing(byte[] payload, WebSocketWriteCompleteListener listener) {
        ChannelPromise channelPromise = this.channel.newPromise();
        channelPromise.addListener((GenericFutureListener)listener);
        this.channel.writeAndFlush((Object)new PingWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload)), channelPromise);
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload) {
        this.channel.writeAndFlush((Object)new PongWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload)), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload, WebSocketWriteCompleteListener listener) {
        ChannelPromise channelPromise = this.channel.newPromise();
        channelPromise.addListener((GenericFutureListener)listener);
        this.channel.writeAndFlush((Object)new PongWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload)), channelPromise);
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        if (this.channel.isOpen()) {
            this.channel.writeAndFlush((Object)new CloseWebSocketFrame(1000, "normal closure"));
        }
    }

    public void close(int statusCode, String reason) {
        this.onClose(statusCode, reason);
        this.listeners.clear();
        this.releaseBufferedFrames();
    }

    public void onError(Throwable t) {
        for (WebSocketListener listener : this.listeners) {
            try {
                listener.onError(t);
            }
            catch (Throwable t2) {
                LOGGER.error("WebSocketListener.onError crash", t2);
            }
        }
        this.releaseBufferedFrames();
    }

    public void onClose(int code, String reason) {
        for (WebSocketListener l : this.listeners) {
            try {
                if (l instanceof WebSocketCloseCodeReasonListener) {
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(l)).onClose(this, code, reason);
                }
                l.onClose(this);
            }
            catch (Throwable t) {
                l.onError(t);
            }
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }

    private boolean hasWebSocketByteListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWebSocketTextListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public WebSocket addWebSocketListener(WebSocketListener l) {
        this.listeners.add(l);
        this.interestedInByteMessages = this.interestedInByteMessages || l instanceof WebSocketByteListener;
        this.interestedInTextMessages = this.interestedInTextMessages || l instanceof WebSocketTextListener;
        return this;
    }

    @Override
    public WebSocket removeWebSocketListener(WebSocketListener l) {
        this.listeners.remove(l);
        if (l instanceof WebSocketByteListener) {
            this.interestedInByteMessages = this.hasWebSocketByteListener();
        }
        if (l instanceof WebSocketTextListener) {
            this.interestedInTextMessages = this.hasWebSocketTextListener();
        }
        return this;
    }

    private void notifyByteListeners(byte[] message) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            ((WebSocketByteListener)WebSocketByteListener.class.cast(listener)).onMessage(message);
        }
    }

    private void notifyTextListeners(String message) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            ((WebSocketTextListener)WebSocketTextListener.class.cast(listener)).onMessage(message);
        }
    }

    public void onBinaryFrame(BinaryWebSocketFrame frame) {
        if (this.interestedInByteMessages) {
            this.notifyByteListeners(ByteBufUtils.byteBuf2Bytes((ByteBuf)frame.content()));
        }
    }

    public void onTextFrame(TextWebSocketFrame frame) {
        if (this.interestedInTextMessages) {
            try {
                this.notifyTextListeners(Utf8ByteBufCharsetDecoder.decodeUtf8((ByteBuf)frame.content()));
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void onPing(PingWebSocketFrame frame) {
        byte[] bytes = ByteBufUtils.byteBuf2Bytes((ByteBuf)frame.content());
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPingListener)) continue;
            ((WebSocketPingListener)WebSocketPingListener.class.cast(listener)).onPing(bytes);
        }
    }

    public void onPong(PongWebSocketFrame frame) {
        byte[] bytes = ByteBufUtils.byteBuf2Bytes((ByteBuf)frame.content());
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPongListener)) continue;
            ((WebSocketPongListener)WebSocketPongListener.class.cast(listener)).onPong(bytes);
        }
    }
}

