/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;

public interface WebSocketWriteCompleteListener
extends FutureListener<Void> {
    public void onComplete(WriteCompleteResult var1);

    default public void operationComplete(Future<Void> future) throws Exception {
        if (future.isSuccess()) {
            this.onComplete(WriteCompleteResult.SUCCEEDED);
        } else {
            this.onComplete(WriteCompleteResult.failed(future.cause()));
        }
    }

    public static interface WriteCompleteResult {
        public static final WriteCompleteResult SUCCEEDED = new WriteCompleteResult(){

            @Override
            public Throwable getFailure() {
                return null;
            }

            @Override
            public boolean isSuccess() {
                return true;
            }

            @Override
            public boolean isFailed() {
                return false;
            }
        };

        public static WriteCompleteResult failed(final Throwable t) {
            return new WriteCompleteResult(){

                @Override
                public Throwable getFailure() {
                    return t;
                }

                @Override
                public boolean isSuccess() {
                    return false;
                }

                @Override
                public boolean isFailed() {
                    return true;
                }
            };
        }

        public Throwable getFailure();

        public boolean isSuccess();

        public boolean isFailed();
    }
}

