/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.handler;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;

public class BodyDeferringAsyncHandler
implements AsyncHandler<Response> {
    private final Response.ResponseBuilder responseBuilder = new Response.ResponseBuilder();
    private final CountDownLatch headersArrived = new CountDownLatch(1);
    private final OutputStream output;
    private boolean responseSet;
    private volatile Response response;
    private volatile Throwable throwable;
    private final Semaphore semaphore = new Semaphore(1);

    public BodyDeferringAsyncHandler(OutputStream os) {
        this.output = os;
        this.responseSet = false;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.throwable = t;
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.headersArrived.countDown();
            this.semaphore.release();
        }
        try {
            this.closeOut();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.responseBuilder.reset();
        this.responseBuilder.accumulate(responseStatus);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        this.responseBuilder.accumulate(headers);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onTrailingHeadersReceived(HttpHeaders headers) throws Exception {
        this.responseBuilder.accumulate(headers);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        if (!this.responseSet) {
            this.response = this.responseBuilder.build();
            this.responseSet = true;
            this.headersArrived.countDown();
        }
        this.output.write(bodyPart.getBodyPartBytes());
        return AsyncHandler.State.CONTINUE;
    }

    protected void closeOut() throws IOException {
        try {
            this.output.flush();
        }
        finally {
            this.output.close();
        }
    }

    @Override
    public Response onCompleted() throws IOException {
        if (!this.responseSet) {
            this.response = this.responseBuilder.build();
            this.responseSet = true;
        }
        this.headersArrived.countDown();
        this.closeOut();
        try {
            this.semaphore.acquire();
            if (this.throwable != null) {
                IOException ioe = new IOException(this.throwable.getMessage());
                ioe.initCause(this.throwable);
                throw ioe;
            }
            Response ioe = this.responseBuilder.build();
            return ioe;
        }
        catch (InterruptedException e) {
            Response response = null;
            return response;
        }
        finally {
            this.semaphore.release();
        }
    }

    public Response getResponse() throws InterruptedException, IOException {
        this.headersArrived.await();
        try {
            this.semaphore.acquire();
            if (this.throwable != null) {
                throw new IOException(this.throwable.getMessage(), this.throwable);
            }
            Response response = this.response;
            return response;
        }
        finally {
            this.semaphore.release();
        }
    }

    public static class BodyDeferringInputStream
    extends FilterInputStream {
        private final Future<Response> future;
        private final BodyDeferringAsyncHandler bdah;

        public BodyDeferringInputStream(Future<Response> future, BodyDeferringAsyncHandler bdah, InputStream in) {
            super(in);
            this.future = future;
            this.bdah = bdah;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                this.getLastResponse();
            }
            catch (ExecutionException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e.getCause());
                throw ioe;
            }
            catch (InterruptedException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }

        public Response getAsapResponse() throws InterruptedException, IOException {
            return this.bdah.getResponse();
        }

        public Response getLastResponse() throws InterruptedException, ExecutionException {
            return this.future.get();
        }
    }
}

