/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.lang.reflect.Method;
import org.asynchttpclient.config.AsyncHttpClientConfigDefaults;
import org.asynchttpclient.config.AsyncHttpClientConfigHelper;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class AsyncHttpClientDefaultsTest {
    public void testDefaultMaxTotalConnections() {
        Assert.assertEquals((int)AsyncHttpClientConfigDefaults.defaultMaxConnections(), (int)-1);
        this.testIntegerSystemProperty("maxConnections", "defaultMaxConnections", "100");
    }

    public void testDefaultMaxConnectionPerHost() {
        Assert.assertEquals((int)AsyncHttpClientConfigDefaults.defaultMaxConnectionsPerHost(), (int)-1);
        this.testIntegerSystemProperty("maxConnectionsPerHost", "defaultMaxConnectionsPerHost", "100");
    }

    public void testDefaultConnectTimeOut() {
        Assert.assertEquals((int)AsyncHttpClientConfigDefaults.defaultConnectTimeout(), (int)5000);
        this.testIntegerSystemProperty("connectTimeout", "defaultConnectTimeout", "100");
    }

    public void testDefaultPooledConnectionIdleTimeout() {
        Assert.assertEquals((int)AsyncHttpClientConfigDefaults.defaultPooledConnectionIdleTimeout(), (int)60000);
        this.testIntegerSystemProperty("pooledConnectionIdleTimeout", "defaultPooledConnectionIdleTimeout", "100");
    }

    public void testDefaultReadTimeout() {
        Assert.assertEquals((int)AsyncHttpClientConfigDefaults.defaultReadTimeout(), (int)60000);
        this.testIntegerSystemProperty("readTimeout", "defaultReadTimeout", "100");
    }

    public void testDefaultRequestTimeout() {
        Assert.assertEquals((int)AsyncHttpClientConfigDefaults.defaultRequestTimeout(), (int)60000);
        this.testIntegerSystemProperty("requestTimeout", "defaultRequestTimeout", "100");
    }

    public void testDefaultConnectionTtl() {
        Assert.assertEquals((int)AsyncHttpClientConfigDefaults.defaultConnectionTtl(), (int)-1);
        this.testIntegerSystemProperty("connectionTtl", "defaultConnectionTtl", "100");
    }

    public void testDefaultFollowRedirect() {
        Assert.assertFalse((boolean)AsyncHttpClientConfigDefaults.defaultFollowRedirect());
        this.testBooleanSystemProperty("followRedirect", "defaultFollowRedirect", "true");
    }

    public void testDefaultMaxRedirects() {
        Assert.assertEquals((int)AsyncHttpClientConfigDefaults.defaultMaxRedirects(), (int)5);
        this.testIntegerSystemProperty("maxRedirects", "defaultMaxRedirects", "100");
    }

    public void testDefaultCompressionEnforced() {
        Assert.assertFalse((boolean)AsyncHttpClientConfigDefaults.defaultCompressionEnforced());
        this.testBooleanSystemProperty("compressionEnforced", "defaultCompressionEnforced", "true");
    }

    public void testDefaultUserAgent() {
        Assert.assertEquals((String)AsyncHttpClientConfigDefaults.defaultUserAgent(), (String)"AHC/2.1");
        this.testStringSystemProperty("userAgent", "defaultUserAgent", "MyAHC");
    }

    public void testDefaultUseProxySelector() {
        Assert.assertFalse((boolean)AsyncHttpClientConfigDefaults.defaultUseProxySelector());
        this.testBooleanSystemProperty("useProxySelector", "defaultUseProxySelector", "true");
    }

    public void testDefaultUseProxyProperties() {
        Assert.assertFalse((boolean)AsyncHttpClientConfigDefaults.defaultUseProxyProperties());
        this.testBooleanSystemProperty("useProxyProperties", "defaultUseProxyProperties", "true");
    }

    public void testDefaultStrict302Handling() {
        Assert.assertFalse((boolean)AsyncHttpClientConfigDefaults.defaultStrict302Handling());
        this.testBooleanSystemProperty("strict302Handling", "defaultStrict302Handling", "true");
    }

    public void testDefaultAllowPoolingConnection() {
        Assert.assertTrue((boolean)AsyncHttpClientConfigDefaults.defaultKeepAlive());
        this.testBooleanSystemProperty("keepAlive", "defaultKeepAlive", "false");
    }

    public void testDefaultMaxRequestRetry() {
        Assert.assertEquals((int)AsyncHttpClientConfigDefaults.defaultMaxRequestRetry(), (int)5);
        this.testIntegerSystemProperty("maxRequestRetry", "defaultMaxRequestRetry", "100");
    }

    public void testDefaultDisableUrlEncodingForBoundRequests() {
        Assert.assertFalse((boolean)AsyncHttpClientConfigDefaults.defaultDisableUrlEncodingForBoundRequests());
        this.testBooleanSystemProperty("disableUrlEncodingForBoundRequests", "defaultDisableUrlEncodingForBoundRequests", "true");
    }

    public void testDefaultUseInsecureTrustManager() {
        Assert.assertFalse((boolean)AsyncHttpClientConfigDefaults.defaultUseInsecureTrustManager());
        this.testBooleanSystemProperty("useInsecureTrustManager", "defaultUseInsecureTrustManager", "false");
    }

    private void testIntegerSystemProperty(String propertyName, String methodName, String value) {
        String previous = System.getProperty("org.asynchttpclient." + propertyName);
        System.setProperty("org.asynchttpclient." + propertyName, value);
        AsyncHttpClientConfigHelper.reloadProperties();
        try {
            Method method = AsyncHttpClientConfigDefaults.class.getMethod(methodName, new Class[0]);
            Assert.assertEquals((Object)method.invoke(null, new Object[0]), (Object)Integer.parseInt(value));
        }
        catch (Exception e) {
            Assert.fail((String)("Couldn't find or execute method : " + methodName), (Throwable)e);
        }
        if (previous != null) {
            System.setProperty("org.asynchttpclient." + propertyName, previous);
        } else {
            System.clearProperty("org.asynchttpclient." + propertyName);
        }
    }

    private void testBooleanSystemProperty(String propertyName, String methodName, String value) {
        String previous = System.getProperty("org.asynchttpclient." + propertyName);
        System.setProperty("org.asynchttpclient." + propertyName, value);
        AsyncHttpClientConfigHelper.reloadProperties();
        try {
            Method method = AsyncHttpClientConfigDefaults.class.getMethod(methodName, new Class[0]);
            Assert.assertEquals((Object)method.invoke(null, new Object[0]), (Object)Boolean.parseBoolean(value));
        }
        catch (Exception e) {
            Assert.fail((String)("Couldn't find or execute method : " + methodName), (Throwable)e);
        }
        if (previous != null) {
            System.setProperty("org.asynchttpclient." + propertyName, previous);
        } else {
            System.clearProperty("org.asynchttpclient." + propertyName);
        }
    }

    private void testStringSystemProperty(String propertyName, String methodName, String value) {
        String previous = System.getProperty("org.asynchttpclient." + propertyName);
        System.setProperty("org.asynchttpclient." + propertyName, value);
        AsyncHttpClientConfigHelper.reloadProperties();
        try {
            Method method = AsyncHttpClientConfigDefaults.class.getMethod(methodName, new Class[0]);
            Assert.assertEquals((Object)method.invoke(null, new Object[0]), (Object)value);
        }
        catch (Exception e) {
            Assert.fail((String)("Couldn't find or execute method : " + methodName), (Throwable)e);
        }
        if (previous != null) {
            System.setProperty("org.asynchttpclient." + propertyName, previous);
        } else {
            System.clearProperty("org.asynchttpclient." + propertyName);
        }
    }
}

