/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AuthTimeoutTest
extends AbstractBasicTest {
    private static final int REQUEST_TIMEOUT = 1000;
    private static final int SHORT_FUTURE_TIMEOUT = 500;
    private static final int LONG_FUTURE_TIMEOUT = 1500;
    private Server server2;

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector1 = TestUtils.addHttpConnector(this.server);
        TestUtils.addBasicAuthHandler(this.server, (Handler)this.configureHandler());
        this.server.start();
        this.port1 = connector1.getLocalPort();
        this.server2 = new Server();
        ServerConnector connector2 = TestUtils.addHttpConnector(this.server2);
        TestUtils.addDigestAuthHandler(this.server2, (Handler)this.configureHandler());
        this.server2.start();
        this.port2 = connector2.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        super.tearDownGlobal();
        this.server2.stop();
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void basicAuthTimeoutTest() throws Throwable {
        try (AsyncHttpClient client = this.newClient();){
            this.execute(client, true, false).get(1500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw e.getCause();
        }
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void basicPreemptiveAuthTimeoutTest() throws Throwable {
        try (AsyncHttpClient client = this.newClient();){
            this.execute(client, true, true).get(1500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw e.getCause();
        }
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void digestAuthTimeoutTest() throws Throwable {
        try (AsyncHttpClient client = this.newClient();){
            this.execute(client, false, false).get(1500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw e.getCause();
        }
    }

    @Test(expectedExceptions={TimeoutException.class}, enabled=false)
    public void digestPreemptiveAuthTimeoutTest() throws Throwable {
        try (AsyncHttpClient client = this.newClient();){
            this.execute(client, false, true).get(1500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw e.getCause();
        }
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void basicAuthFutureTimeoutTest() throws Throwable {
        try (AsyncHttpClient client = this.newClient();){
            this.execute(client, true, false).get(500L, TimeUnit.MILLISECONDS);
        }
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void basicPreemptiveAuthFutureTimeoutTest() throws Throwable {
        try (AsyncHttpClient client = this.newClient();){
            this.execute(client, true, true).get(500L, TimeUnit.MILLISECONDS);
        }
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void digestAuthFutureTimeoutTest() throws Throwable {
        try (AsyncHttpClient client = this.newClient();){
            this.execute(client, false, false).get(500L, TimeUnit.MILLISECONDS);
        }
    }

    @Test(expectedExceptions={TimeoutException.class}, enabled=false)
    public void digestPreemptiveAuthFutureTimeoutTest() throws Throwable {
        try (AsyncHttpClient client = this.newClient();){
            this.execute(client, false, true).get(500L, TimeUnit.MILLISECONDS);
        }
    }

    private AsyncHttpClient newClient() {
        return Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(1000));
    }

    protected Future<Response> execute(AsyncHttpClient client, boolean basic, boolean preemptive) {
        String url;
        Realm.Builder realm;
        if (basic) {
            realm = Dsl.basicAuthRealm((String)"user", (String)"admin");
            url = this.getTargetUrl();
        } else {
            realm = Dsl.digestAuthRealm((String)"user", (String)"admin");
            url = this.getTargetUrl2();
            if (preemptive) {
                realm.setRealmName("MyRealm");
                realm.setAlgorithm("MD5");
                realm.setQop("auth");
                realm.setNonce("fFDVc60re9zt8fFDvht0tNrYuvqrcchN");
            }
        }
        return ((BoundRequestBuilder)client.prepareGet(url).setRealm(realm.setUsePreemptiveAuth(preemptive).build())).execute();
    }

    @Override
    protected String getTargetUrl() {
        return "http://localhost:" + this.port1 + "/";
    }

    @Override
    protected String getTargetUrl2() {
        return "http://localhost:" + this.port2 + "/";
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new IncompleteResponseHandler();
    }

    private class IncompleteResponseHandler
    extends AbstractHandler {
        private IncompleteResponseHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            response.setIntHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), 1000);
            out.write(0);
            out.flush();
            try {
                Thread.sleep(1600L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

