/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.EchoHandler;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BasicHttpProxyToHttpTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicHttpProxyToHttpTest.class);
    private int httpPort;
    private int proxyPort;
    private Server httpServer;
    private Server proxy;

    @BeforeClass
    public void setUpGlobal() throws Exception {
        this.httpServer = new Server();
        ServerConnector connector1 = TestUtils.addHttpConnector(this.httpServer);
        this.httpServer.setHandler((Handler)new EchoHandler());
        this.httpServer.start();
        this.httpPort = connector1.getLocalPort();
        this.proxy = new Server();
        ServerConnector connector2 = TestUtils.addHttpConnector(this.proxy);
        ServletHandler servletHandler = new ServletHandler();
        ServletHolder servletHolder = servletHandler.addServletWithMapping(BasicAuthProxyServlet.class, "/*");
        servletHolder.setInitParameter("maxThreads", "20");
        this.proxy.setHandler((Handler)servletHandler);
        this.proxy.start();
        this.proxyPort = connector2.getLocalPort();
        LOGGER.info("Local HTTP Server (" + this.httpPort + "), Proxy (" + this.proxyPort + ") started successfully");
    }

    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() {
        if (this.proxy != null) {
            try {
                this.proxy.stop();
            }
            catch (Exception e) {
                LOGGER.error("Failed to properly close proxy", (Throwable)e);
            }
        }
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                LOGGER.error("Failed to properly close server", (Throwable)e);
            }
        }
    }

    @Test
    public void nonPreemptiveProxyAuthWithPlainHttpTarget() throws IOException, InterruptedException, ExecutionException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            String targetUrl = "http://localhost:" + this.httpPort + "/foo/bar";
            Request request = ((RequestBuilder)Dsl.get((String)targetUrl).setProxyServer(Dsl.proxyServer((String)"127.0.0.1", (int)this.proxyPort).setRealm(Dsl.realm((Realm.AuthScheme)Realm.AuthScheme.BASIC, (String)"johndoe", (String)"pass")))).build();
            ListenableFuture responseFuture = client.executeRequest(request);
            Response response = (Response)responseFuture.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)"/foo/bar", (String)response.getHeader((CharSequence)"X-pathInfo"));
        }
    }

    public static class BasicAuthProxyServlet
    extends ProxyServlet {
        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            LOGGER.debug(">>> got a request !");
            String authorization = request.getHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString());
            if (authorization == null) {
                response.setStatus(407);
                response.setHeader(HttpHeaderNames.PROXY_AUTHENTICATE.toString(), "Basic realm=\"Fake Realm\"");
                response.getOutputStream().flush();
            } else if (authorization.equals("Basic am9obmRvZTpwYXNz")) {
                super.service(request, response);
            } else {
                response.setStatus(401);
                response.getOutputStream().flush();
            }
        }
    }
}

