/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ServerSocketFactory;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MultipleHeaderTest
extends AbstractBasicTest {
    private ExecutorService executorService;
    private ServerSocket serverSocket;
    private Future<?> voidFuture;

    @Override
    @BeforeClass
    public void setUpGlobal() throws Exception {
        this.serverSocket = ServerSocketFactory.getDefault().createServerSocket(0);
        this.port1 = this.serverSocket.getLocalPort();
        this.executorService = Executors.newFixedThreadPool(1);
        this.voidFuture = this.executorService.submit(() -> {
            Socket socket;
            while ((socket = this.serverSocket.accept()) != null) {
                OutputStreamWriter outputStreamWriter;
                InputStream inputStream = socket.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String req = reader.readLine().split(" ")[1];
                int i = inputStream.available();
                long l = inputStream.skip(i);
                Assert.assertEquals((long)l, (long)i);
                socket.shutdownInput();
                if (req.endsWith("MultiEnt")) {
                    outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
                    outputStreamWriter.append("HTTP/1.0 200 OK\nConnection: close\nContent-Type: text/plain; charset=iso-8859-1\nContent-Length: 2\nContent-Length: 1\n\n0\n");
                    outputStreamWriter.flush();
                    socket.shutdownOutput();
                    continue;
                }
                if (!req.endsWith("MultiOther")) continue;
                outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
                outputStreamWriter.append("HTTP/1.0 200 OK\nConnection: close\nContent-Type: text/plain; charset=iso-8859-1\nContent-Length: 1\nX-Forwarded-For: abc\nX-Forwarded-For: def\n\n0\n");
                outputStreamWriter.flush();
                socket.shutdownOutput();
            }
            return null;
        });
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.voidFuture.cancel(true);
        this.executorService.shutdownNow();
        this.serverSocket.close();
    }

    @Test
    public void testMultipleOtherHeaders() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        final String[] xffHeaders = new String[]{null, null};
        try (AsyncHttpClient ahc = Dsl.asyncHttpClient();){
            Request req = Dsl.get((String)("http://localhost:" + this.port1 + "/MultiOther")).build();
            final CountDownLatch latch = new CountDownLatch(1);
            ahc.executeRequest(req, (AsyncHandler)new AsyncHandler<Void>(){

                public void onThrowable(Throwable t) {
                    t.printStackTrace(System.out);
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart objectHttpResponseBodyPart) {
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onStatusReceived(HttpResponseStatus objectHttpResponseStatus) {
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onHeadersReceived(HttpHeaders response) {
                    int i = 0;
                    for (String header : response.getAll("X-Forwarded-For")) {
                        xffHeaders[i++] = header;
                    }
                    latch.countDown();
                    return AsyncHandler.State.CONTINUE;
                }

                public Void onCompleted() {
                    return null;
                }
            }).get(3L, TimeUnit.SECONDS);
            if (!latch.await(2L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Time out");
            }
            Assert.assertNotNull((Object)xffHeaders[0]);
            Assert.assertNotNull((Object)xffHeaders[1]);
            try {
                Assert.assertEquals((String)xffHeaders[0], (String)"abc");
                Assert.assertEquals((String)xffHeaders[1], (String)"def");
            }
            catch (AssertionError ex) {
                Assert.assertEquals((String)xffHeaders[1], (String)"abc");
                Assert.assertEquals((String)xffHeaders[0], (String)"def");
            }
        }
    }

    @Test
    public void testMultipleEntityHeaders() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        final String[] clHeaders = new String[]{null, null};
        try (AsyncHttpClient ahc = Dsl.asyncHttpClient();){
            Request req = Dsl.get((String)("http://localhost:" + this.port1 + "/MultiEnt")).build();
            final CountDownLatch latch = new CountDownLatch(1);
            ahc.executeRequest(req, (AsyncHandler)new AsyncHandler<Void>(){

                public void onThrowable(Throwable t) {
                    t.printStackTrace(System.out);
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart objectHttpResponseBodyPart) {
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onStatusReceived(HttpResponseStatus objectHttpResponseStatus) {
                    return AsyncHandler.State.CONTINUE;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public AsyncHandler.State onHeadersReceived(HttpHeaders response) {
                    try {
                        int i = 0;
                        for (String header : response.getAll((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                            clHeaders[i++] = header;
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                public Void onCompleted() {
                    return null;
                }
            }).get(3L, TimeUnit.SECONDS);
            if (!latch.await(2L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Time out");
            }
            Assert.assertNotNull((Object)clHeaders[0]);
            Assert.assertNotNull((Object)clHeaders[1]);
            try {
                Assert.assertEquals((String)clHeaders[0], (String)"2");
                Assert.assertEquals((String)clHeaders[1], (String)"1");
            }
            catch (Throwable ex) {
                Assert.assertEquals((String)clHeaders[0], (String)"1");
                Assert.assertEquals((String)clHeaders[1], (String)"2");
            }
        }
    }
}

