/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.oauth;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.RequestBuilderBase;
import org.asynchttpclient.SignatureCalculator;
import org.asynchttpclient.oauth.ConsumerKey;
import org.asynchttpclient.oauth.OAuthSignatureCalculator;
import org.asynchttpclient.oauth.OAuthSignatureCalculatorInstance;
import org.asynchttpclient.oauth.RequestToken;
import org.asynchttpclient.oauth.StaticOAuthSignatureCalculator;
import org.asynchttpclient.util.Utf8UrlEncoder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OAuthSignatureCalculatorTest {
    private static final String TOKEN_KEY = "nnch734d00sl2jdk";
    private static final String TOKEN_SECRET = "pfkkdhi9sl3r4s00";
    private static final String NONCE = "kllo9940pd9333jh";
    private static final long TIMESTAMP = 1191242096L;
    private static final String CONSUMER_KEY = "dpf43f3p2l4k3l03";
    private static final String CONSUMER_SECRET = "kd94hf93k423kf44";

    private void testSignatureBaseString(Request request) throws NoSuchAlgorithmException {
        String signatureBaseString = new OAuthSignatureCalculatorInstance().signatureBaseString(new ConsumerKey("9djdj82h48djs9d2", CONSUMER_SECRET), new RequestToken("kkk9d7dh3k39sjv7", TOKEN_SECRET), request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams(), 137131201L, "7d8f3e4a").toString();
        Assert.assertEquals((String)signatureBaseString, (String)"POST&http%3A%2F%2Fexample.com%2Frequest&a2%3Dr%2520b%26a3%3D2%2520q%26a3%3Da%26b5%3D%253D%25253D%26c%2540%3D%26c2%3D%26oauth_consumer_key%3D9djdj82h48djs9d2%26oauth_nonce%3D7d8f3e4a%26oauth_signature_method%3DHMAC-SHA1%26oauth_timestamp%3D137131201%26oauth_token%3Dkkk9d7dh3k39sjv7%26oauth_version%3D1.0");
    }

    private void testSignatureBaseStringWithEncodableOAuthToken(Request request) throws NoSuchAlgorithmException {
        String signatureBaseString = new OAuthSignatureCalculatorInstance().signatureBaseString(new ConsumerKey("9djdj82h48djs9d2", CONSUMER_SECRET), new RequestToken("kkk9d7dh3k39sjv7", TOKEN_SECRET), request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams(), 137131201L, Utf8UrlEncoder.percentEncodeQueryElement((String)"ZLc92RAkooZcIO/0cctl0Q==")).toString();
        Assert.assertEquals((String)signatureBaseString, (String)"POST&http%3A%2F%2Fexample.com%2Frequest&a2%3Dr%2520b%26a3%3D2%2520q%26a3%3Da%26b5%3D%253D%25253D%26c%2540%3D%26c2%3D%26oauth_consumer_key%3D9djdj82h48djs9d2%26oauth_nonce%3DZLc92RAkooZcIO%252F0cctl0Q%253D%253D%26oauth_signature_method%3DHMAC-SHA1%26oauth_timestamp%3D137131201%26oauth_token%3Dkkk9d7dh3k39sjv7%26oauth_version%3D1.0");
    }

    @Test
    public void testSignatureBaseStringWithProperlyEncodedUri() throws NoSuchAlgorithmException {
        Request request = ((RequestBuilder)((RequestBuilder)Dsl.post((String)"http://example.com/request?b5=%3D%253D&a3=a&c%40=&a2=r%20b").addFormParam("c2", "")).addFormParam("a3", "2 q")).build();
        this.testSignatureBaseString(request);
        this.testSignatureBaseStringWithEncodableOAuthToken(request);
    }

    @Test
    public void testSignatureBaseStringWithRawUri() throws NoSuchAlgorithmException {
        Request request = ((RequestBuilder)((RequestBuilder)Dsl.post((String)"http://example.com/request?b5=%3D%253D&a3=a&c%40=&a2=r b").addFormParam("c2", "")).addFormParam("a3", "2 q")).build();
        this.testSignatureBaseString(request);
        this.testSignatureBaseStringWithEncodableOAuthToken(request);
    }

    @Test
    public void testGetCalculateSignature() throws NoSuchAlgorithmException, InvalidKeyException {
        Request request = ((RequestBuilder)((RequestBuilder)Dsl.get((String)"http://photos.example.net/photos").addQueryParam("file", "vacation.jpg")).addQueryParam("size", "original")).build();
        String signature = new OAuthSignatureCalculatorInstance().computeSignature(new ConsumerKey(CONSUMER_KEY, CONSUMER_SECRET), new RequestToken(TOKEN_KEY, TOKEN_SECRET), request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams(), 1191242096L, NONCE);
        Assert.assertEquals((String)signature, (String)"tR3+Ty81lMeYAr/Fid0kMTYa/WM=");
    }

    @Test
    public void testPostCalculateSignature() throws UnsupportedEncodingException {
        StaticOAuthSignatureCalculator calc = new StaticOAuthSignatureCalculator(new ConsumerKey(CONSUMER_KEY, CONSUMER_SECRET), new RequestToken(TOKEN_KEY, TOKEN_SECRET), NONCE, 1191242096L);
        Request req = ((RequestBuilder)((RequestBuilder)((RequestBuilder)Dsl.post((String)"http://photos.example.net/photos").addFormParam("file", "vacation.jpg")).addFormParam("size", "original")).setSignatureCalculator((SignatureCalculator)calc)).build();
        String authHeader = req.getHeaders().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        Matcher m = Pattern.compile("oauth_signature=\"(.+?)\"").matcher(authHeader);
        Assert.assertEquals((boolean)m.find(), (boolean)true);
        String encodedSig = m.group(1);
        String sig = URLDecoder.decode(encodedSig, "UTF-8");
        Assert.assertEquals((String)sig, (String)"wPkvxykrw+BTdCcGqKr+3I+PsiM=");
    }

    @Test
    public void testGetWithRequestBuilder() throws UnsupportedEncodingException {
        StaticOAuthSignatureCalculator calc = new StaticOAuthSignatureCalculator(new ConsumerKey(CONSUMER_KEY, CONSUMER_SECRET), new RequestToken(TOKEN_KEY, TOKEN_SECRET), NONCE, 1191242096L);
        Request req = ((RequestBuilder)((RequestBuilder)((RequestBuilder)Dsl.get((String)"http://photos.example.net/photos").addQueryParam("file", "vacation.jpg")).addQueryParam("size", "original")).setSignatureCalculator((SignatureCalculator)calc)).build();
        List params = req.getQueryParams();
        Assert.assertEquals((int)params.size(), (int)2);
        String authHeader = req.getHeaders().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        Matcher m = Pattern.compile("oauth_signature=\"(.+?)\"").matcher(authHeader);
        Assert.assertEquals((boolean)m.find(), (boolean)true);
        String encodedSig = m.group(1);
        String sig = URLDecoder.decode(encodedSig, "UTF-8");
        Assert.assertEquals((String)sig, (String)"tR3+Ty81lMeYAr/Fid0kMTYa/WM=");
        Assert.assertEquals((String)req.getUrl(), (String)"http://photos.example.net/photos?file=vacation.jpg&size=original");
    }

    @Test
    public void testGetWithRequestBuilderAndQuery() throws UnsupportedEncodingException {
        StaticOAuthSignatureCalculator calc = new StaticOAuthSignatureCalculator(new ConsumerKey(CONSUMER_KEY, CONSUMER_SECRET), new RequestToken(TOKEN_KEY, TOKEN_SECRET), NONCE, 1191242096L);
        Request req = ((RequestBuilder)Dsl.get((String)"http://photos.example.net/photos?file=vacation.jpg&size=original").setSignatureCalculator((SignatureCalculator)calc)).build();
        List params = req.getQueryParams();
        Assert.assertEquals((int)params.size(), (int)2);
        String authHeader = req.getHeaders().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        Matcher m = Pattern.compile("oauth_signature=\"(.+?)\"").matcher(authHeader);
        Assert.assertTrue((boolean)m.find());
        String encodedSig = m.group(1);
        String sig = URLDecoder.decode(encodedSig, "UTF-8");
        Assert.assertEquals((String)sig, (String)"tR3+Ty81lMeYAr/Fid0kMTYa/WM=");
        Assert.assertEquals((String)req.getUrl(), (String)"http://photos.example.net/photos?file=vacation.jpg&size=original");
        Assert.assertEquals((String)authHeader, (String)"OAuth oauth_consumer_key=\"dpf43f3p2l4k3l03\", oauth_token=\"nnch734d00sl2jdk\", oauth_signature_method=\"HMAC-SHA1\", oauth_signature=\"tR3%2BTy81lMeYAr%2FFid0kMTYa%2FWM%3D\", oauth_timestamp=\"1191242096\", oauth_nonce=\"kllo9940pd9333jh\", oauth_version=\"1.0\"");
    }

    @Test
    public void testWithNullRequestToken() throws NoSuchAlgorithmException {
        Request request = Dsl.get((String)"http://photos.example.net/photos?file=vacation.jpg&size=original").build();
        String signatureBaseString = new OAuthSignatureCalculatorInstance().signatureBaseString(new ConsumerKey("9djdj82h48djs9d2", CONSUMER_SECRET), new RequestToken(null, null), request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams(), 137131201L, Utf8UrlEncoder.percentEncodeQueryElement((String)"ZLc92RAkooZcIO/0cctl0Q==")).toString();
        Assert.assertEquals((String)signatureBaseString, (String)"GET&http%3A%2F%2Fphotos.example.net%2Fphotos&file%3Dvacation.jpg%26oauth_consumer_key%3D9djdj82h48djs9d2%26oauth_nonce%3DZLc92RAkooZcIO%252F0cctl0Q%253D%253D%26oauth_signature_method%3DHMAC-SHA1%26oauth_timestamp%3D137131201%26oauth_version%3D1.0%26size%3Doriginal");
    }

    @Test
    public void testWithStarQueryParameterValue() throws NoSuchAlgorithmException {
        Request request = Dsl.get((String)"http://term.ie/oauth/example/request_token.php?testvalue=*").build();
        String signatureBaseString = new OAuthSignatureCalculatorInstance().signatureBaseString(new ConsumerKey("key", "secret"), new RequestToken(null, null), request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams(), 1469019732L, "6ad17f97334700f3ec2df0631d5b7511").toString();
        Assert.assertEquals((String)signatureBaseString, (String)"GET&http%3A%2F%2Fterm.ie%2Foauth%2Fexample%2Frequest_token.php&oauth_consumer_key%3Dkey%26oauth_nonce%3D6ad17f97334700f3ec2df0631d5b7511%26oauth_signature_method%3DHMAC-SHA1%26oauth_timestamp%3D1469019732%26oauth_version%3D1.0%26testvalue%3D%252A");
    }

    @Test
    public void testSignatureGenerationWithAsteriskInPath() throws InvalidKeyException, NoSuchAlgorithmException {
        ConsumerKey consumerKey = new ConsumerKey("key", "secret");
        RequestToken requestToken = new RequestToken(null, null);
        String nonce = "6ad17f97334700f3ec2df0631d5b7511";
        long timestamp = 1469019732L;
        Request request = Dsl.get((String)"http://example.com/oauth/example/*path/wi*th/asterisks*").build();
        String expectedSignature = "cswi/v3ZqhVkTyy5MGqW841BxDA=";
        String actualSignature = new OAuthSignatureCalculatorInstance().computeSignature(consumerKey, requestToken, request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams(), timestamp, nonce);
        Assert.assertEquals((String)actualSignature, (String)expectedSignature);
        String generatedAuthHeader = new OAuthSignatureCalculatorInstance().computeAuthorizationHeader(consumerKey, requestToken, actualSignature, timestamp, nonce);
        Assert.assertTrue((boolean)generatedAuthHeader.contains("oauth_signature=\"cswi%2Fv3ZqhVkTyy5MGqW841BxDA%3D\""));
    }

    @Test
    public void testPercentEncodeKeyValues() {
        String keyValue = "\u3b05\f\u375b";
        ConsumerKey consumer = new ConsumerKey(keyValue, "secret");
        RequestToken reqToken = new RequestToken(keyValue, "secret");
        OAuthSignatureCalculator calc = new OAuthSignatureCalculator(consumer, reqToken);
        RequestBuilder reqBuilder = (RequestBuilder)new RequestBuilder().setUrl("https://api.dropbox.com/1/oauth/access_token?oauth_token=%EC%AD%AE%E3%AC%82%EC%BE%B8%E7%9C%9A%E8%BD%BD%E1%94%A5%E8%AD%AF%E8%98%93%E0%B9%99%E5%9E%96%EF%92%A2%EA%BC%97%EA%90%B0%E4%8A%91%E8%97%BF%EF%A8%BB%E5%B5%B1%DA%98%E2%90%87%E2%96%96%EE%B5%B5%E7%B9%AD%E9%AD%87%E3%BE%93%E5%AF%92%EE%BC%8F%E3%A0%B2%E8%A9%AB%E1%8B%97%EC%BF%80%EA%8F%AE%ED%87%B0%E5%97%B7%E9%97%BF%E8%BF%87%E6%81%A3%E5%BB%A1%EC%86%92%E8%92%81%E2%B9%94%EB%B6%86%E9%AE%8A%E6%94%B0%EE%AC%B5%E6%A0%99%EB%8B%AD%EB%BA%81%E7%89%9F%E5%B3%B7%EA%9D%B7%EC%A4%9C%E0%BC%BA%EB%BB%B9%ED%84%A9%E8%A5%B9%E8%AF%A0%E3%AC%85%0C%E3%9D%9B%E8%B9%8B%E6%BF%8C%EB%91%98%E7%8B%B3%E7%BB%A8%E2%A7%BB%E6%A3%84%E1%AB%B2%E8%8D%93%E4%BF%98%E9%B9%B9%EF%9A%8B%E8%A5%93");
        Request req = reqBuilder.build();
        calc.calculateAndAddSignature(req, (RequestBuilderBase)reqBuilder);
    }
}

