/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BasicAuthTest;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MultipartBasicAuthTest
extends AbstractBasicTest {
    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector1 = TestUtils.addHttpConnector(this.server);
        TestUtils.addBasicAuthHandler(this.server, (Handler)this.configureHandler());
        this.server.start();
        this.port1 = connector1.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new BasicAuthTest.SimpleHandler();
    }

    private void expectExecutionException(Function<BoundRequestBuilder, BoundRequestBuilder> f) throws Throwable {
        File file = TestUtils.createTempFile(0x100000);
        ExecutionException executionException = null;
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            try {
                for (int i = 0; i < 20; ++i) {
                    f.apply((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).addBodyPart((Part)new FilePart("test", file, HttpHeaderValues.APPLICATION_OCTET_STREAM.toString(), StandardCharsets.UTF_8))).execute().get();
                }
            }
            catch (ExecutionException e) {
                executionException = e;
            }
        }
        Assert.assertNotNull((Object)executionException, (String)"Expected ExecutionException");
        throw executionException.getCause();
    }

    @Test(expectedExceptions={IOException.class})
    public void noRealmCausesServerToCloseSocket() throws Throwable {
        this.expectExecutionException(rb -> rb);
    }

    @Test(expectedExceptions={IOException.class})
    public void unauthorizedNonPreemptiveRealmCausesServerToCloseSocket() throws Throwable {
        this.expectExecutionException(rb -> (BoundRequestBuilder)rb.setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin")));
    }

    private void expectSuccess(Function<BoundRequestBuilder, BoundRequestBuilder> f) throws Exception {
        File file = TestUtils.createTempFile(0x100000);
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            for (int i = 0; i < 20; ++i) {
                Response response = (Response)f.apply((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).addBodyPart((Part)new FilePart("test", file, HttpHeaderValues.APPLICATION_OCTET_STREAM.toString(), StandardCharsets.UTF_8))).execute().get();
                Assert.assertEquals((int)response.getStatusCode(), (int)200);
                Assert.assertEquals((int)response.getResponseBodyAsBytes().length, (int)Integer.valueOf(response.getHeader((CharSequence)("X-" + HttpHeaderNames.CONTENT_LENGTH))));
            }
        }
    }

    @Test
    public void authorizedPreemptiveRealmWorks() throws Exception {
        this.expectSuccess(rb -> (BoundRequestBuilder)rb.setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin").setUsePreemptiveAuth(true)));
    }

    @Test
    public void authorizedNonPreemptiveRealmWorksWithExpectContinue() throws Exception {
        this.expectSuccess(rb -> (BoundRequestBuilder)((BoundRequestBuilder)rb.setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin"))).setHeader((CharSequence)HttpHeaderNames.EXPECT, (Object)HttpHeaderValues.CONTINUE));
    }
}

