/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.test;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoHandler
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoHandler.class);

    public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        String requestBodyLength;
        Enumeration i;
        String queryString;
        String headerName;
        LOGGER.debug("Echo received request {} on path {}", (Object)request, (Object)pathInContext);
        if (httpRequest.getHeader("X-HEAD") != null) {
            httpResponse.setContentLength(1);
        }
        if (httpRequest.getHeader("X-ISO") != null) {
            httpResponse.setContentType("text/html;charset=ISO-8859-1");
        } else {
            httpResponse.setContentType("text/html;charset=UTF-8");
        }
        if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
            httpResponse.addHeader("Allow", "GET,HEAD,POST,OPTIONS,TRACE");
        }
        Enumeration e = httpRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            headerName = (String)e.nextElement();
            if (headerName.startsWith("LockThread")) {
                int sleepTime = httpRequest.getIntHeader(headerName);
                try {
                    Thread.sleep(sleepTime == -1 ? 40L : (long)(sleepTime * 1000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (headerName.startsWith("X-redirect")) {
                httpResponse.sendRedirect(httpRequest.getHeader("X-redirect"));
                return;
            }
            if (headerName.startsWith("X-fail")) {
                byte[] body = "custom error message".getBytes(StandardCharsets.US_ASCII);
                httpResponse.addHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(body.length));
                httpResponse.setStatus(417);
                httpResponse.getOutputStream().write(body);
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
                return;
            }
            httpResponse.addHeader("X-" + headerName, httpRequest.getHeader(headerName));
        }
        String pathInfo = httpRequest.getPathInfo();
        if (pathInfo != null) {
            httpResponse.addHeader("X-pathInfo", pathInfo);
        }
        if ((queryString = httpRequest.getQueryString()) != null) {
            httpResponse.addHeader("X-queryString", queryString);
        }
        httpResponse.addHeader("X-KEEP-ALIVE", httpRequest.getRemoteAddr() + ":" + httpRequest.getRemotePort());
        Cookie[] cs = httpRequest.getCookies();
        if (cs != null) {
            for (Cookie c : cs) {
                httpResponse.addCookie(c);
            }
        }
        if ((i = httpRequest.getParameterNames()).hasMoreElements()) {
            StringBuilder requestBody = new StringBuilder();
            while (i.hasMoreElements()) {
                headerName = (String)i.nextElement();
                httpResponse.addHeader("X-" + headerName, httpRequest.getParameter(headerName));
                requestBody.append(headerName);
                requestBody.append("_");
            }
            if (requestBody.length() > 0) {
                String body = requestBody.toString();
                httpResponse.getOutputStream().write(body.getBytes());
            }
        }
        if ((requestBodyLength = httpRequest.getHeader("X-" + HttpHeaderNames.CONTENT_LENGTH)) != null) {
            byte[] requestBodyBytes = IOUtils.toByteArray((InputStream)httpRequest.getInputStream());
            int total = requestBodyBytes.length;
            httpResponse.addIntHeader("X-" + HttpHeaderNames.CONTENT_LENGTH, total);
            String md5 = TestUtils.md5(requestBodyBytes, 0, total);
            httpResponse.addHeader(HttpHeaderNames.CONTENT_MD5.toString(), md5);
            httpResponse.getOutputStream().write(requestBodyBytes, 0, total);
        } else {
            int size = 16384;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if (size > 0) {
                int read = 0;
                while (read > -1) {
                    byte[] bytes = new byte[size];
                    read = httpRequest.getInputStream().read(bytes);
                    if (read <= 0) continue;
                    httpResponse.getOutputStream().write(bytes, 0, read);
                }
            }
        }
        request.setHandled(true);
        httpResponse.getOutputStream().flush();
        httpResponse.getOutputStream().close();
    }
}

