/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.webdav;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.servlets.WebdavServlet;
import org.apache.catalina.startup.Tomcat;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.webdav.WebDavCompletionHandlerBase;
import org.asynchttpclient.webdav.WebDavResponse;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class WebdavTest {
    private Tomcat tomcat;
    private int port1;

    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        String path = new File(".").getAbsolutePath() + "/target";
        this.tomcat = new Tomcat();
        this.tomcat.setHostname("localhost");
        this.tomcat.setPort(0);
        this.tomcat.setBaseDir(path);
        Context ctx = this.tomcat.addContext("", path);
        Tomcat.addServlet((Context)ctx, (String)"webdav", (Servlet)new WebdavServlet(){

            public void init(final ServletConfig config) throws ServletException {
                super.init(new ServletConfig(){

                    public String getServletName() {
                        return config.getServletName();
                    }

                    public ServletContext getServletContext() {
                        return config.getServletContext();
                    }

                    public Enumeration<String> getInitParameterNames() {
                        return config.getInitParameterNames();
                    }

                    public String getInitParameter(String name) {
                        switch (name) {
                            case "readonly": {
                                return "false";
                            }
                            case "listings": {
                                return "true";
                            }
                        }
                        return config.getInitParameter(name);
                    }
                });
            }
        });
        ctx.addServletMappingDecoded("/*", "webdav");
        this.tomcat.start();
        this.port1 = this.tomcat.getConnector().getLocalPort();
    }

    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.tomcat.stop();
    }

    private String getTargetUrl() {
        return String.format("http://localhost:%s/folder1", this.port1);
    }

    @AfterMethod(alwaysRun=true)
    public void clean() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            c.executeRequest(Dsl.delete((String)this.getTargetUrl())).get();
        }
    }

    @Test
    public void mkcolWebDavTest1() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request mkcolRequest = ((RequestBuilder)new RequestBuilder("MKCOL").setUrl(this.getTargetUrl())).build();
            Response response = (Response)c.executeRequest(mkcolRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)201);
        }
    }

    @Test
    public void mkcolWebDavTest2() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request mkcolRequest = ((RequestBuilder)new RequestBuilder("MKCOL").setUrl(this.getTargetUrl() + "/folder2")).build();
            Response response = (Response)c.executeRequest(mkcolRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)409);
        }
    }

    @Test
    public void basicPropFindWebDavTest() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request propFindRequest = ((RequestBuilder)new RequestBuilder("PROPFIND").setUrl(this.getTargetUrl())).build();
            Response response = (Response)c.executeRequest(propFindRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)404);
        }
    }

    @Test
    public void propFindWebDavTest() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request mkcolRequest = ((RequestBuilder)new RequestBuilder("MKCOL").setUrl(this.getTargetUrl())).build();
            Response response = (Response)c.executeRequest(mkcolRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)201);
            Request putRequest = ((RequestBuilder)Dsl.put((String)(this.getTargetUrl() + "/Test.txt")).setBody("this is a test")).build();
            response = (Response)c.executeRequest(putRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)201);
            Request propFindRequest = ((RequestBuilder)new RequestBuilder("PROPFIND").setUrl(this.getTargetUrl() + "/Test.txt")).build();
            response = (Response)c.executeRequest(propFindRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)207);
            Assert.assertTrue((boolean)response.getResponseBody().contains("HTTP/1.1 200 OK"), (String)("Got " + response.getResponseBody()));
        }
    }

    @Test
    public void propFindCompletionHandlerWebDavTest() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request mkcolRequest = ((RequestBuilder)new RequestBuilder("MKCOL").setUrl(this.getTargetUrl())).build();
            Response response = (Response)c.executeRequest(mkcolRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)201);
            Request propFindRequest = ((RequestBuilder)new RequestBuilder("PROPFIND").setUrl(this.getTargetUrl())).build();
            WebDavResponse webDavResponse = (WebDavResponse)c.executeRequest(propFindRequest, (AsyncHandler)new WebDavCompletionHandlerBase<WebDavResponse>(){

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                }

                public WebDavResponse onCompleted(WebDavResponse response) {
                    return response;
                }
            }).get();
            Assert.assertEquals((int)webDavResponse.getStatusCode(), (int)207);
            Assert.assertTrue((boolean)webDavResponse.getResponseBody().contains("HTTP/1.1 200 OK"), (String)("Got " + response.getResponseBody()));
        }
    }
}

