/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.AbstractBasicWebSocketTest;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ByteMessageTest
extends AbstractBasicWebSocketTest {
    private static final byte[] ECHO_BYTES = "ECHO".getBytes(StandardCharsets.UTF_8);

    private void echoByte0(boolean enableCompression) throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setEnablewebSocketCompression(enableCompression));){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<byte[]> receivedBytes = new AtomicReference<byte[]>(new byte[0]);
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onBinaryFrame(byte[] frame, boolean finalFragment, int rsv) {
                    receivedBytes.set(frame);
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendBinaryFrame(ECHO_BYTES);
            latch.await();
            Assert.assertEquals((byte[])receivedBytes.get(), (byte[])ECHO_BYTES);
        }
    }

    @Test
    public void echoByte() throws Exception {
        this.echoByte0(false);
    }

    @Test
    public void echoByteCompressed() throws Exception {
        this.echoByte0(true);
    }

    @Test
    public void echoTwoMessagesTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<Object> text = new AtomicReference<Object>(null);
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onBinaryFrame(byte[] frame, boolean finalFragment, int rsv) {
                    if (text.get() == null) {
                        text.set(frame);
                    } else {
                        byte[] n = new byte[((byte[])text.get()).length + frame.length];
                        System.arraycopy(text.get(), 0, n, 0, ((byte[])text.get()).length);
                        System.arraycopy(frame, 0, n, ((byte[])text.get()).length, frame.length);
                        text.set(n);
                    }
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendBinaryFrame(ECHO_BYTES);
            websocket.sendBinaryFrame(ECHO_BYTES);
            latch.await();
            Assert.assertEquals((byte[])text.get(), (byte[])"ECHOECHO".getBytes());
        }
    }

    @Test
    public void echoOnOpenMessagesTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<Object> text = new AtomicReference<Object>(null);
            c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                    websocket.sendBinaryFrame(ECHO_BYTES);
                    websocket.sendBinaryFrame(ECHO_BYTES);
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onBinaryFrame(byte[] frame, boolean finalFragment, int rsv) {
                    if (text.get() == null) {
                        text.set(frame);
                    } else {
                        byte[] n = new byte[((byte[])text.get()).length + frame.length];
                        System.arraycopy(text.get(), 0, n, 0, ((byte[])text.get()).length);
                        System.arraycopy(frame, 0, n, ((byte[])text.get()).length, frame.length);
                        text.set(n);
                    }
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((byte[])text.get(), (byte[])"ECHOECHO".getBytes());
        }
    }

    @Test
    public void echoFragments() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<Object> text = new AtomicReference<Object>(null);
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onBinaryFrame(byte[] frame, boolean finalFragment, int rsv) {
                    if (text.get() == null) {
                        text.set(frame);
                    } else {
                        byte[] n = new byte[((byte[])text.get()).length + frame.length];
                        System.arraycopy(text.get(), 0, n, 0, ((byte[])text.get()).length);
                        System.arraycopy(frame, 0, n, ((byte[])text.get()).length, frame.length);
                        text.set(n);
                    }
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendBinaryFrame(ECHO_BYTES, false, 0);
            websocket.sendContinuationFrame(ECHO_BYTES, true, 0);
            latch.await();
            Assert.assertEquals((byte[])text.get(), (byte[])"ECHOECHO".getBytes());
        }
    }
}

