/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.AbstractBasicWebSocketTest;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TextMessageTest
extends AbstractBasicWebSocketTest {
    @Test(timeOut=60000L)
    public void onOpen() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                    text.set("OnOpen");
                    latch.countDown();
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnOpen");
        }
    }

    @Test(timeOut=60000L)
    public void onEmptyListenerTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            WebSocket websocket = null;
            try {
                websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().build()).get();
            }
            catch (Throwable t) {
                Assert.fail();
            }
            Assert.assertTrue((websocket != null ? 1 : 0) != 0);
        }
    }

    @Test(timeOut=60000L, expectedExceptions={UnknownHostException.class})
    public void onFailureTest() throws Throwable {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            c.prepareGet("ws://abcdefg").execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().build()).get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test(timeOut=60000L)
    public void onTimeoutCloseTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    text.set("OnClose");
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnClose");
        }
    }

    @Test(timeOut=60000L)
    public void onClose() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    text.set("OnClose");
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendCloseFrame();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnClose");
        }
    }

    @Test(timeOut=60000L)
    public void echoText() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    text.set(payload);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendTextFrame("ECHO");
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHO");
        }
    }

    @Test(timeOut=60000L)
    public void echoDoubleListenerText() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    text.set(payload);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).addWebSocketListener(new WebSocketListener(){

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    text.set((String)text.get() + payload);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendTextFrame("ECHO");
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHOECHO");
        }
    }

    @Test
    public void echoTwoMessagesTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<String> text = new AtomicReference<String>("");
            c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    text.set((String)text.get() + payload);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                    websocket.sendTextFrame("ECHO");
                    websocket.sendTextFrame("ECHO");
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHOECHO");
        }
    }

    @Test
    public void echoFragments() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    text.set(payload);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendTextFrame("ECHO", false, 0);
            websocket.sendContinuationFrame("ECHO", true, 0);
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHOECHO");
        }
    }

    @Test(timeOut=60000L)
    public void echoTextAndThenClose() throws Throwable {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch textLatch = new CountDownLatch(1);
            final CountDownLatch closeLatch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    text.set((String)text.get() + payload);
                    textLatch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    closeLatch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    closeLatch.countDown();
                }
            }).build()).get();
            websocket.sendTextFrame("ECHO");
            textLatch.await();
            websocket.sendTextFrame("CLOSE");
            closeLatch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHO");
        }
    }
}

