/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.channel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MaxTotalConnectionTest
extends AbstractBasicTest {
    @Test(groups={"online"})
    public void testMaxTotalConnectionsExceedingException() throws IOException {
        String[] urls = new String[]{"http://google.com", "http://github.com/"};
        DefaultAsyncHttpClientConfig config = Dsl.config().setConnectTimeout(1000).setRequestTimeout(5000).setKeepAlive(false).setMaxConnections(1).setMaxConnectionsPerHost(1).build();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            int i;
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (String url : urls) {
                futures.add(client.prepareGet(url).execute());
            }
            boolean caughtError = false;
            for (i = 0; i < urls.length; ++i) {
                try {
                    ((ListenableFuture)futures.get(i)).get();
                    continue;
                }
                catch (Exception e) {
                    caughtError = true;
                    break;
                }
            }
            Assert.assertEquals((int)1, (int)i);
            Assert.assertTrue((boolean)caughtError);
        }
    }

    @Test(groups={"online"})
    public void testMaxTotalConnections() throws Exception {
        String[] urls = new String[]{"http://google.com", "http://gatling.io"};
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicReference ex = new AtomicReference();
        final AtomicReference failedUrl = new AtomicReference();
        DefaultAsyncHttpClientConfig config = Dsl.config().setConnectTimeout(1000).setRequestTimeout(5000).setKeepAlive(false).setMaxConnections(2).setMaxConnectionsPerHost(1).build();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            String[] stringArray = urls;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String url;
                final String thisUrl = url = stringArray[i];
                client.prepareGet(url).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                    public Response onCompleted(Response response) throws Exception {
                        Response r = super.onCompleted(response);
                        latch.countDown();
                        return r;
                    }

                    public void onThrowable(Throwable t) {
                        super.onThrowable(t);
                        ex.set(t);
                        failedUrl.set(thisUrl);
                        latch.countDown();
                    }
                });
            }
            latch.await();
            Assert.assertNull(ex.get());
            Assert.assertNull(failedUrl.get());
        }
    }
}

