/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EventPipelineTest
extends AbstractBasicTest {
    @Test
    public void asyncPipelineTest() throws Exception {
        Consumer<Channel> httpAdditionalPipelineInitializer = channel -> channel.pipeline().addBefore("inflater", "copyEncodingHeader", (ChannelHandler)new CopyEncodingHandler());
        try (AsyncHttpClient p = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setHttpAdditionalChannelInitializer(httpAdditionalPipelineInitializer));){
            final CountDownLatch l = new CountDownLatch(1);
            p.executeRequest(Dsl.get((String)this.getTargetUrl()), (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)200);
                        Assert.assertEquals((String)response.getHeader((CharSequence)"X-Original-Content-Encoding"), (String)"<original encoding>");
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    private static class CopyEncodingHandler
    extends ChannelInboundHandlerAdapter {
        private CopyEncodingHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object e) {
            if (e instanceof HttpMessage) {
                HttpMessage m = (HttpMessage)e;
                m.headers().set("X-Original-Content-Encoding", (Object)"<original encoding>");
            }
            ctx.fireChannelRead(e);
        }
    }
}

