/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import org.asynchttpclient.netty.channel.ConnectionSemaphore;

class SemaphoreRunner {
    final ConnectionSemaphore semaphore;
    final Thread acquireThread;
    volatile long acquireTime;
    volatile Exception acquireException;

    public SemaphoreRunner(ConnectionSemaphore semaphore, Object partitionKey) {
        this.semaphore = semaphore;
        this.acquireThread = new Thread(() -> {
            long beforeAcquire = System.currentTimeMillis();
            try {
                semaphore.acquireChannelLock(partitionKey);
            }
            catch (Exception e) {
                this.acquireException = e;
            }
            finally {
                this.acquireTime = System.currentTimeMillis() - beforeAcquire;
            }
        });
    }

    public void acquire() {
        this.acquireThread.start();
    }

    public void interrupt() {
        this.acquireThread.interrupt();
    }

    public void await() {
        try {
            this.acquireThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean finished() {
        return !this.acquireThread.isAlive();
    }

    public long getAcquireTime() {
        return this.acquireTime;
    }

    public Exception getAcquireException() {
        return this.acquireException;
    }
}

