/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.asynchttpclient.exception.TooManyConnectionsException;
import org.asynchttpclient.exception.TooManyConnectionsPerHostException;
import org.asynchttpclient.netty.channel.CombinedConnectionSemaphore;
import org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.asynchttpclient.netty.channel.MaxConnectionSemaphore;
import org.asynchttpclient.netty.channel.PerHostConnectionSemaphore;
import org.asynchttpclient.netty.channel.SemaphoreRunner;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SemaphoreTest {
    static final int CHECK_ACQUIRE_TIME__PERMITS = 10;
    static final int CHECK_ACQUIRE_TIME__TIMEOUT = 100;
    static final int NON_DETERMINISTIC__INVOCATION_COUNT = 10;
    static final int NON_DETERMINISTIC__SUCCESS_PERCENT = 70;
    private final Object PK = new Object();

    @DataProvider(name="permitsAndRunnersCount")
    public Object[][] permitsAndRunnersCount() {
        Object[][] objects = new Object[100][];
        int row = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                objects[row++] = new Object[]{i, j};
            }
        }
        return objects;
    }

    @Test(timeOut=1000L, dataProvider="permitsAndRunnersCount")
    public void maxConnectionCheckPermitCount(int permitCount, int runnerCount) {
        this.allSemaphoresCheckPermitCount((ConnectionSemaphore)new MaxConnectionSemaphore(permitCount, 0), permitCount, runnerCount);
    }

    @Test(timeOut=1000L, dataProvider="permitsAndRunnersCount")
    public void perHostCheckPermitCount(int permitCount, int runnerCount) {
        this.allSemaphoresCheckPermitCount((ConnectionSemaphore)new PerHostConnectionSemaphore(permitCount, 0), permitCount, runnerCount);
    }

    @Test(timeOut=3000L, dataProvider="permitsAndRunnersCount")
    public void combinedCheckPermitCount(int permitCount, int runnerCount) {
        this.allSemaphoresCheckPermitCount((ConnectionSemaphore)new CombinedConnectionSemaphore(permitCount, permitCount, 0), permitCount, runnerCount);
        this.allSemaphoresCheckPermitCount((ConnectionSemaphore)new CombinedConnectionSemaphore(0, permitCount, 0), permitCount, runnerCount);
        this.allSemaphoresCheckPermitCount((ConnectionSemaphore)new CombinedConnectionSemaphore(permitCount, 0, 0), permitCount, runnerCount);
    }

    private void allSemaphoresCheckPermitCount(ConnectionSemaphore semaphore, int permitCount, int runnerCount) {
        List<SemaphoreRunner> runners = IntStream.range(0, runnerCount).mapToObj(i -> new SemaphoreRunner(semaphore, this.PK)).collect(Collectors.toList());
        runners.forEach(SemaphoreRunner::acquire);
        runners.forEach(SemaphoreRunner::await);
        long tooManyConnectionsCount = runners.stream().map(SemaphoreRunner::getAcquireException).filter(Objects::nonNull).filter(e -> e instanceof IOException).count();
        long acquired = runners.stream().map(SemaphoreRunner::getAcquireException).filter(Objects::isNull).count();
        int expectedAcquired = permitCount > 0 ? Math.min(permitCount, runnerCount) : runnerCount;
        AssertJUnit.assertEquals((long)expectedAcquired, (long)acquired);
        AssertJUnit.assertEquals((long)((long)runnerCount - acquired), (long)tooManyConnectionsCount);
    }

    @Test(timeOut=1000L, invocationCount=10, successPercentage=70)
    public void maxConnectionCheckAcquireTime() {
        this.checkAcquireTime((ConnectionSemaphore)new MaxConnectionSemaphore(10, 100));
    }

    @Test(timeOut=1000L, invocationCount=10, successPercentage=70)
    public void perHostCheckAcquireTime() {
        this.checkAcquireTime((ConnectionSemaphore)new PerHostConnectionSemaphore(10, 100));
    }

    @Test(timeOut=1000L, invocationCount=10, successPercentage=70)
    public void combinedCheckAcquireTime() {
        this.checkAcquireTime((ConnectionSemaphore)new CombinedConnectionSemaphore(10, 10, 100));
    }

    private void checkAcquireTime(ConnectionSemaphore semaphore) {
        List<SemaphoreRunner> runners = IntStream.range(0, 20).mapToObj(i -> new SemaphoreRunner(semaphore, this.PK)).collect(Collectors.toList());
        long acquireStartTime = System.currentTimeMillis();
        runners.forEach(SemaphoreRunner::acquire);
        runners.forEach(SemaphoreRunner::await);
        long timeToAcquire = System.currentTimeMillis() - acquireStartTime;
        AssertJUnit.assertTrue((String)("Semaphore acquired too soon: " + timeToAcquire + " ms"), (timeToAcquire >= 50L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)("Semaphore acquired too late: " + timeToAcquire + " ms"), (timeToAcquire <= 400L ? 1 : 0) != 0);
    }

    @Test(timeOut=1000L)
    public void maxConnectionCheckRelease() throws IOException {
        this.checkRelease((ConnectionSemaphore)new MaxConnectionSemaphore(1, 0));
    }

    @Test(timeOut=1000L)
    public void perHostCheckRelease() throws IOException {
        this.checkRelease((ConnectionSemaphore)new PerHostConnectionSemaphore(1, 0));
    }

    @Test(timeOut=1000L)
    public void combinedCheckRelease() throws IOException {
        this.checkRelease((ConnectionSemaphore)new CombinedConnectionSemaphore(1, 1, 0));
    }

    private void checkRelease(ConnectionSemaphore semaphore) throws IOException {
        semaphore.acquireChannelLock(this.PK);
        boolean tooManyCaught = false;
        try {
            semaphore.acquireChannelLock(this.PK);
        }
        catch (TooManyConnectionsException | TooManyConnectionsPerHostException e) {
            tooManyCaught = true;
        }
        AssertJUnit.assertTrue((boolean)tooManyCaught);
        tooManyCaught = false;
        semaphore.releaseChannelLock(this.PK);
        try {
            semaphore.acquireChannelLock(this.PK);
        }
        catch (TooManyConnectionsException | TooManyConnectionsPerHostException e) {
            tooManyCaught = true;
        }
        AssertJUnit.assertFalse((boolean)tooManyCaught);
    }
}

