/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.oauth;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilderBase;
import org.asynchttpclient.SignatureCalculator;
import org.asynchttpclient.oauth.ConsumerKey;
import org.asynchttpclient.oauth.OAuthSignatureCalculatorInstance;
import org.asynchttpclient.oauth.RequestToken;

class StaticOAuthSignatureCalculator
implements SignatureCalculator {
    private final ConsumerKey consumerKey;
    private final RequestToken requestToken;
    private final String nonce;
    private final long timestamp;

    StaticOAuthSignatureCalculator(ConsumerKey consumerKey, RequestToken requestToken, String nonce, long timestamp) {
        this.consumerKey = consumerKey;
        this.requestToken = requestToken;
        this.nonce = nonce;
        this.timestamp = timestamp;
    }

    public void calculateAndAddSignature(Request request, RequestBuilderBase<?> requestBuilder) {
        try {
            String authorization = new OAuthSignatureCalculatorInstance().computeAuthorizationHeader(this.consumerKey, this.requestToken, request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams(), this.timestamp, this.nonce);
            requestBuilder.setHeader((CharSequence)HttpHeaderNames.AUTHORIZATION, authorization);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

