/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.proxy;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NTLMProxyTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new NTLMProxyHandler();
    }

    @Test
    public void ntlmProxyTest() throws IOException, InterruptedException, ExecutionException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            Request request = ((RequestBuilder)Dsl.get((String)"http://localhost").setProxyServer(this.ntlmProxy())).build();
            ListenableFuture responseFuture = client.executeRequest(request);
            int status = ((Response)responseFuture.get()).getStatusCode();
            Assert.assertEquals((int)status, (int)200);
        }
    }

    private ProxyServer ntlmProxy() {
        Realm realm = Dsl.ntlmAuthRealm((String)"Zaphod", (String)"Beeblebrox").setNtlmDomain("Ursa-Minor").setNtlmHost("LightCity").build();
        return Dsl.proxyServer((String)"localhost", (int)this.port2).setRealm(realm).build();
    }

    public static class NTLMProxyHandler
    extends AbstractHandler {
        private AtomicInteger state = new AtomicInteger();

        public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            String authorization = httpRequest.getHeader("Proxy-Authorization");
            boolean asExpected = false;
            switch (this.state.getAndIncrement()) {
                case 0: {
                    if (authorization != null) break;
                    httpResponse.setStatus(407);
                    httpResponse.setHeader("Proxy-Authenticate", "NTLM");
                    asExpected = true;
                    break;
                }
                case 1: {
                    if (!authorization.equals("NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==")) break;
                    httpResponse.setStatus(407);
                    httpResponse.setHeader("Proxy-Authenticate", "NTLM TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==");
                    asExpected = true;
                    break;
                }
                case 2: {
                    if (!authorization.equals("NTLM TlRMTVNTUAADAAAAGAAYAEgAAAAYABgAYAAAABQAFAB4AAAADAAMAIwAAAASABIAmAAAAAAAAACqAAAAAYIAAgUBKAoAAAAPrYfKbe/jRoW5xDxHeoxC1gBmfWiS5+iX4OAN4xBKG/IFPwfH3agtPEia6YnhsADTVQBSAFMAQQAtAE0ASQBOAE8AUgBaAGEAcABoAG8AZABMAEkARwBIAFQAQwBJAFQAWQA=")) break;
                    httpResponse.setStatus(200);
                    asExpected = true;
                    break;
                }
            }
            if (!asExpected) {
                httpResponse.setStatus(403);
            }
            httpResponse.setContentLength(0);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

