/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.reactivestreams;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.Future;
import org.asynchttpclient.reactivestreams.HttpStaticFileServerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpStaticFileServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpStaticFileServer.class);
    private static EventLoopGroup bossGroup;
    private static EventLoopGroup workerGroup;

    public static void start(int port) throws Exception {
        bossGroup = new NioEventLoopGroup(1);
        workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new HttpStaticFileServerInitializer());
        b.bind(port).sync().channel();
        LOGGER.info("Open your web browser and navigate to http://localhost:" + port + '/');
    }

    public static void shutdown() {
        Future bossFuture = bossGroup.shutdownGracefully();
        Future workerFuture = workerGroup.shutdownGracefully();
        try {
            bossFuture.await();
            workerFuture.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

