/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body;

import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.asynchttpclient.request.body.generator.UnboundedQueueFeedableBodyGenerator;
import org.asynchttpclient.test.TestUtils;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public class ChunkingTest
extends AbstractBasicTest {
    @Test
    public void testBufferLargerThanFileWithStreamBodyGenerator() throws Throwable {
        this.doTestWithInputStreamBodyGenerator(new BufferedInputStream(Files.newInputStream(TestUtils.LARGE_IMAGE_FILE.toPath(), new OpenOption[0]), 400000));
    }

    @Test
    public void testBufferSmallThanFileWithStreamBodyGenerator() throws Throwable {
        this.doTestWithInputStreamBodyGenerator(new BufferedInputStream(Files.newInputStream(TestUtils.LARGE_IMAGE_FILE.toPath(), new OpenOption[0])));
    }

    @Test
    public void testDirectFileWithStreamBodyGenerator() throws Throwable {
        this.doTestWithInputStreamBodyGenerator(Files.newInputStream(TestUtils.LARGE_IMAGE_FILE.toPath(), new OpenOption[0]));
    }

    @Test
    public void testDirectFileWithFeedableBodyGenerator() throws Throwable {
        this.doTestWithFeedableBodyGenerator(Files.newInputStream(TestUtils.LARGE_IMAGE_FILE.toPath(), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestWithInputStreamBodyGenerator(InputStream is) throws Throwable {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)this.httpClientBuilder());){
            ListenableFuture responseFuture = c.executeRequest((RequestBuilder)Dsl.post((String)this.getTargetUrl()).setBody((BodyGenerator)new InputStreamBodyGenerator(is)));
            this.waitForAndAssertResponse((ListenableFuture<Response>)responseFuture);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestWithFeedableBodyGenerator(InputStream is) throws Throwable {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)this.httpClientBuilder());){
            UnboundedQueueFeedableBodyGenerator feedableBodyGenerator = new UnboundedQueueFeedableBodyGenerator();
            Request r = ((RequestBuilder)Dsl.post((String)this.getTargetUrl()).setBody((BodyGenerator)feedableBodyGenerator)).build();
            ListenableFuture responseFuture = c.executeRequest(r);
            this.feed((FeedableBodyGenerator)feedableBodyGenerator, is);
            this.waitForAndAssertResponse((ListenableFuture<Response>)responseFuture);
        }
        finally {
            is.close();
        }
    }

    private void feed(FeedableBodyGenerator feedableBodyGenerator, InputStream is) throws Exception {
        try (InputStream inputStream = is;){
            int i;
            byte[] buffer = new byte[512];
            while ((i = inputStream.read(buffer)) > -1) {
                byte[] chunk = new byte[i];
                System.arraycopy(buffer, 0, chunk, 0, i);
                feedableBodyGenerator.feed(Unpooled.wrappedBuffer((byte[])chunk), false);
            }
        }
        feedableBodyGenerator.feed(Unpooled.EMPTY_BUFFER, true);
    }

    private DefaultAsyncHttpClientConfig.Builder httpClientBuilder() {
        return Dsl.config().setKeepAlive(true).setMaxConnectionsPerHost(1).setMaxConnections(1).setConnectTimeout(1000).setRequestTimeout(1000).setFollowRedirect(true);
    }

    private void waitForAndAssertResponse(ListenableFuture<Response> responseFuture) throws InterruptedException, ExecutionException {
        Response response = (Response)responseFuture.get();
        if (500 == response.getStatusCode()) {
            this.logger.debug("==============\n500 response from call\nHeaders:" + response.getHeaders() + "\n==============\n");
            Assert.assertEquals((int)response.getStatusCode(), (int)500, (String)"Should have 500 status code");
            Assert.assertTrue((boolean)response.getHeader((CharSequence)"X-Exception").contains("invalid.chunk.length"), (String)"Should have failed due to chunking");
            FileAssert.fail((String)("HARD Failing the test due to provided InputStreamBodyGenerator, chunking incorrectly:" + response.getHeader((CharSequence)"X-Exception")));
        } else {
            Assert.assertEquals((byte[])response.getResponseBodyAsBytes(), (byte[])TestUtils.LARGE_IMAGE_BYTES);
        }
    }
}

