/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.multipart.InputStreamPart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InputStreamPartLargeFileTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest req, HttpServletResponse resp) throws IOException {
                int count;
                ServletInputStream in = req.getInputStream();
                byte[] b = new byte[8192];
                int total = 0;
                while ((count = in.read(b)) != -1) {
                    b = new byte[8192];
                    total += count;
                }
                resp.setStatus(200);
                resp.addHeader("X-TRANSFERRED", String.valueOf(total));
                resp.getOutputStream().flush();
                resp.getOutputStream().close();
                baseRequest.setHandled(true);
            }
        };
    }

    @Test
    public void testPutImageFile() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(600000));){
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(TestUtils.LARGE_IMAGE_FILE));
            Response response = (Response)((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).addBodyPart((Part)new InputStreamPart("test", (InputStream)inputStream, TestUtils.LARGE_IMAGE_FILE.getName(), TestUtils.LARGE_IMAGE_FILE.length(), "application/octet-stream", StandardCharsets.UTF_8))).execute().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test
    public void testPutImageFileUnknownSize() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(600000));){
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(TestUtils.LARGE_IMAGE_FILE));
            Response response = (Response)((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).addBodyPart((Part)new InputStreamPart("test", (InputStream)inputStream, TestUtils.LARGE_IMAGE_FILE.getName(), -1L, "application/octet-stream", StandardCharsets.UTF_8))).execute().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test
    public void testPutLargeTextFile() throws Exception {
        File file = TestUtils.createTempFile(0x100000);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(600000));){
            Response response = (Response)((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).addBodyPart((Part)new InputStreamPart("test", (InputStream)inputStream, file.getName(), file.length(), "application/octet-stream", StandardCharsets.UTF_8))).execute().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test
    public void testPutLargeTextFileUnknownSize() throws Exception {
        File file = TestUtils.createTempFile(0x100000);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(600000));){
            Response response = (Response)((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).addBodyPart((Part)new InputStreamPart("test", (InputStream)inputStream, file.getName(), -1L, "application/octet-stream", StandardCharsets.UTF_8))).execute().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }
}

