/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.handler.TransferCompletionHandler;
import org.asynchttpclient.handler.TransferListener;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.FileBodyGenerator;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TransferListenerTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new BasicHandler();
    }

    @Test
    public void basicGetTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final AtomicReference throwable = new AtomicReference();
            final AtomicReference hSent = new AtomicReference();
            final AtomicReference hRead = new AtomicReference();
            final AtomicReference bb = new AtomicReference();
            final AtomicBoolean completed = new AtomicBoolean(false);
            TransferCompletionHandler tl = new TransferCompletionHandler();
            tl.addTransferListener(new TransferListener(){

                public void onRequestHeadersSent(HttpHeaders headers) {
                    hSent.set(headers);
                }

                public void onResponseHeadersReceived(HttpHeaders headers) {
                    hRead.set(headers);
                }

                public void onBytesReceived(byte[] b) {
                    if (b.length != 0) {
                        bb.set(b);
                    }
                }

                public void onBytesSent(long amount, long current, long total) {
                }

                public void onRequestResponseCompleted() {
                    completed.set(true);
                }

                public void onThrowable(Throwable t) {
                    throwable.set(t);
                }
            });
            Response response = (Response)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)tl).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertNotNull(hRead.get());
            Assert.assertNotNull(hSent.get());
            Assert.assertNull(bb.get());
            Assert.assertNull(throwable.get());
        }
    }

    @Test
    public void basicPutFileTest() throws Exception {
        final AtomicReference throwable = new AtomicReference();
        final AtomicReference hSent = new AtomicReference();
        final AtomicReference hRead = new AtomicReference();
        final AtomicInteger bbReceivedLenght = new AtomicInteger(0);
        final AtomicLong bbSentLenght = new AtomicLong(0L);
        final AtomicBoolean completed = new AtomicBoolean(false);
        File file = TestUtils.createTempFile(1024000);
        int timeout = (int)(file.length() / 1000L);
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setConnectTimeout(timeout));){
            TransferCompletionHandler tl = new TransferCompletionHandler();
            tl.addTransferListener(new TransferListener(){

                public void onRequestHeadersSent(HttpHeaders headers) {
                    hSent.set(headers);
                }

                public void onResponseHeadersReceived(HttpHeaders headers) {
                    hRead.set(headers);
                }

                public void onBytesReceived(byte[] b) {
                    bbReceivedLenght.addAndGet(b.length);
                }

                public void onBytesSent(long amount, long current, long total) {
                    bbSentLenght.addAndGet(amount);
                }

                public void onRequestResponseCompleted() {
                    completed.set(true);
                }

                public void onThrowable(Throwable t) {
                    throwable.set(t);
                }
            });
            Response response = (Response)((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).setBody(file)).execute((AsyncHandler)tl).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertNotNull(hRead.get());
            Assert.assertNotNull(hSent.get());
            Assert.assertEquals((long)bbReceivedLenght.get(), (long)file.length(), (String)"Number of received bytes incorrect");
            Assert.assertEquals((long)bbSentLenght.get(), (long)file.length(), (String)"Number of sent bytes incorrect");
        }
    }

    @Test
    public void basicPutFileBodyGeneratorTest() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            final AtomicReference throwable = new AtomicReference();
            final AtomicReference hSent = new AtomicReference();
            final AtomicReference hRead = new AtomicReference();
            final AtomicInteger bbReceivedLenght = new AtomicInteger(0);
            final AtomicLong bbSentLenght = new AtomicLong(0L);
            final AtomicBoolean completed = new AtomicBoolean(false);
            File file = TestUtils.createTempFile(1024000);
            TransferCompletionHandler tl = new TransferCompletionHandler();
            tl.addTransferListener(new TransferListener(){

                public void onRequestHeadersSent(HttpHeaders headers) {
                    hSent.set(headers);
                }

                public void onResponseHeadersReceived(HttpHeaders headers) {
                    hRead.set(headers);
                }

                public void onBytesReceived(byte[] b) {
                    bbReceivedLenght.addAndGet(b.length);
                }

                public void onBytesSent(long amount, long current, long total) {
                    bbSentLenght.addAndGet(amount);
                }

                public void onRequestResponseCompleted() {
                    completed.set(true);
                }

                public void onThrowable(Throwable t) {
                    throwable.set(t);
                }
            });
            Response response = (Response)((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).setBody((BodyGenerator)new FileBodyGenerator(file))).execute((AsyncHandler)tl).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertNotNull(hRead.get());
            Assert.assertNotNull(hSent.get());
            Assert.assertEquals((long)bbReceivedLenght.get(), (long)file.length(), (String)"Number of received bytes incorrect");
            Assert.assertEquals((long)bbSentLenght.get(), (long)file.length(), (String)"Number of sent bytes incorrect");
        }
    }

    private class BasicHandler
    extends AbstractHandler {
        private BasicHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            byte[] bytes;
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                httpResponse.addHeader("X-" + param, httpRequest.getHeader(param));
            }
            int size = 10240;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if ((bytes = new byte[size]).length > 0) {
                int read = 0;
                while (read != -1) {
                    read = httpRequest.getInputStream().read(bytes);
                    if (read <= 0) continue;
                    httpResponse.getOutputStream().write(bytes, 0, read);
                }
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

