/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.asynchttpclient.request.body.multipart.FileLikePart;
import org.asynchttpclient.request.body.multipart.MultipartBody;
import org.asynchttpclient.request.body.multipart.MultipartUtils;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.asynchttpclient.request.body.multipart.part.FileLikeMultipartPart;
import org.asynchttpclient.request.body.multipart.part.PartVisitor;
import org.asynchttpclient.test.TestUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MultipartPartTest {
    @Test
    public void testVisitStart() {
        TestFileLikePart fileLikePart = new TestFileLikePart("Name");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[10]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitStart((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)12, (String)"CounterPartVisitor count for visitStart should match EXTRA_BYTES count plus boundary bytes count");
        }
    }

    @Test
    public void testVisitStartZeroSizedByteArray() {
        TestFileLikePart fileLikePart = new TestFileLikePart("Name");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitStart((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)2, (String)"CounterPartVisitor count for visitStart should match EXTRA_BYTES count when boundary byte array is of size zero");
        }
    }

    @Test
    public void testVisitDispositionHeaderWithoutFileName() {
        TestFileLikePart fileLikePart = new TestFileLikePart("Name");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitDispositionHeader((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)45, (String)"CounterPartVisitor count for visitDispositionHeader should be equal to CRLF_BYTES length + CONTENT_DISPOSITION_BYTES length + part name length when file name is not specified");
        }
    }

    @Test
    public void testVisitDispositionHeaderWithFileName() {
        TestFileLikePart fileLikePart = new TestFileLikePart("baPart", null, null, null, null, "fileName");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitDispositionHeader((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)68, (String)"CounterPartVisitor count for visitDispositionHeader should be equal to CRLF_BYTES length + CONTENT_DISPOSITION_BYTES length + part name length + file name length when both part name and file name are present");
        }
    }

    @Test
    public void testVisitDispositionHeaderWithoutName() {
        TestFileLikePart fileLikePart = new TestFileLikePart(null, null, null, null, null, "fileName");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitDispositionHeader((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)53, (String)"CounterPartVisitor count for visitDispositionHeader should be equal to CRLF_BYTES length + CONTENT_DISPOSITION_BYTES length + file name length when part name is not specified");
        }
    }

    @Test
    public void testVisitContentTypeHeaderWithCharset() {
        TestFileLikePart fileLikePart = new TestFileLikePart(null, "application/test", StandardCharsets.UTF_8, null, null);
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitContentTypeHeader((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)47, (String)"CounterPartVisitor count for visitContentTypeHeader should be equal to CRLF_BYTES length + CONTENT_TYPE_BYTES length + contentType length + charset length");
        }
    }

    @Test
    public void testVisitContentTypeHeaderWithoutCharset() {
        TestFileLikePart fileLikePart = new TestFileLikePart(null, "application/test");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitContentTypeHeader((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)32, (String)"CounterPartVisitor count for visitContentTypeHeader should be equal to CRLF_BYTES length + CONTENT_TYPE_BYTES length + contentType length when charset is not specified");
        }
    }

    @Test
    public void testVisitTransferEncodingHeader() {
        TestFileLikePart fileLikePart = new TestFileLikePart(null, null, null, null, "transferEncoding");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitTransferEncodingHeader((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)45, (String)"CounterPartVisitor count for visitTransferEncodingHeader should be equal to CRLF_BYTES length + CONTENT_TRANSFER_ENCODING_BYTES length + transferEncoding length");
        }
    }

    @Test
    public void testVisitContentIdHeader() {
        TestFileLikePart fileLikePart = new TestFileLikePart(null, null, null, "contentId");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitContentIdHeader((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)23, (String)"CounterPartVisitor count for visitContentIdHeader should be equal toCRLF_BYTES length + CONTENT_ID_BYTES length + contentId length");
        }
    }

    @Test
    public void testVisitCustomHeadersWhenNoCustomHeaders() {
        TestFileLikePart fileLikePart = new TestFileLikePart(null);
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitCustomHeaders((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)0, (String)"CounterPartVisitor count for visitCustomHeaders should be zero for visitCustomHeaders when there are no custom headers");
        }
    }

    @Test
    public void testVisitCustomHeaders() {
        TestFileLikePart fileLikePart = new TestFileLikePart(null);
        fileLikePart.addCustomHeader("custom-header", "header-value");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitCustomHeaders((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)29, (String)"CounterPartVisitor count for visitCustomHeaders should include the length of the custom headers");
        }
    }

    @Test
    public void testVisitEndOfHeaders() {
        TestFileLikePart fileLikePart = new TestFileLikePart(null);
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitEndOfHeaders((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)4, (String)"CounterPartVisitor count for visitEndOfHeaders should be equal to 4");
        }
    }

    @Test
    public void testVisitPreContent() {
        TestFileLikePart fileLikePart = new TestFileLikePart("Name", "application/test", StandardCharsets.UTF_8, "contentId", "transferEncoding", "fileName");
        fileLikePart.addCustomHeader("custom-header", "header-value");
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitPreContent((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)216, (String)"CounterPartVisitor count for visitPreContent should be equal to the sum of the lengths of precontent");
        }
    }

    @Test
    public void testVisitPostContents() {
        TestFileLikePart fileLikePart = new TestFileLikePart(null);
        try (TestMultipartPart multipartPart = new TestMultipartPart(fileLikePart, new byte[0]);){
            PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
            multipartPart.visitPostContent((PartVisitor)counterVisitor);
            Assert.assertEquals((int)counterVisitor.getCount(), (int)2, (String)"CounterPartVisitor count for visitPostContent should be equal to 2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void transferToShouldWriteStringPart() throws IOException, URISyntaxException {
        String text = FileUtils.readFileToString((File)TestUtils.resourceAsFile("test_sample_message.eml"), (Charset)StandardCharsets.UTF_8);
        ArrayList<StringPart> parts = new ArrayList<StringPart>();
        parts.add(new StringPart("test_sample_message.eml", text));
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.set("Cookie", (Object)"open-xchange-public-session-d41d8cd98f00b204e9800998ecf8427e=bfb98150b24f42bd844fc9ef2a9eaad5; open-xchange-secret-TSlq4Cm4nCBnDpBL1Px2A=9a49b76083e34c5ba2ef5c47362313fd; JSESSIONID=6883138728830405130.OX2");
        headers.set("Content-Length", (Object)"9241");
        headers.set("Content-Type", (Object)"multipart/form-data; boundary=5gigAKQyqDCVdlZ1fCkeLlEDDauTNoOOEhRnFg");
        headers.set("Host", (Object)"appsuite.qa.open-xchange.com");
        headers.set("Accept", (Object)"*/*");
        String boundary = "uwyqQolZaSmme019O2kFKvAeHoC14Npp";
        List multipartParts = MultipartUtils.generateMultipartParts(parts, (byte[])boundary.getBytes());
        try (MultipartBody multipartBody = new MultipartBody(multipartParts, "multipart/form-data; boundary=" + boundary, boundary.getBytes());){
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(8192);
            multipartBody.transferTo(byteBuf);
            try {
                byteBuf.toString(StandardCharsets.UTF_8);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    private class TestMultipartPart
    extends FileLikeMultipartPart<TestFileLikePart> {
        TestMultipartPart(TestFileLikePart part, byte[] boundary) {
            super((FileLikePart)part, boundary);
        }

        protected long getContentLength() {
            return 0L;
        }

        protected long transferContentTo(ByteBuf target) {
            return 0L;
        }

        protected long transferContentTo(WritableByteChannel target) {
            return 0L;
        }
    }

    private class TestFileLikePart
    extends FileLikePart {
        TestFileLikePart(String name) {
            this(name, null, null, null, null);
        }

        TestFileLikePart(String name, String contentType) {
            this(name, contentType, null);
        }

        TestFileLikePart(String name, String contentType, Charset charset) {
            this(name, contentType, charset, null);
        }

        TestFileLikePart(String name, String contentType, Charset charset, String contentId) {
            this(name, contentType, charset, contentId, null);
        }

        TestFileLikePart(String name, String contentType, Charset charset, String contentId, String transfertEncoding) {
            this(name, contentType, charset, contentId, transfertEncoding, null);
        }

        TestFileLikePart(String name, String contentType, Charset charset, String contentId, String transfertEncoding, String fileName) {
            super(name, contentType, charset, fileName, contentId, transfertEncoding);
        }
    }
}

