/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.test;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.SslEngineFactory;
import org.asynchttpclient.netty.ssl.JsseSslEngineFactory;
import org.asynchttpclient.util.MessageDigestUtils;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.testng.Assert;

public class TestUtils {
    public static final int TIMEOUT = 30;
    public static final String USER = "user";
    public static final String ADMIN = "admin";
    public static final String TEXT_HTML_CONTENT_TYPE_WITH_UTF_8_CHARSET = "text/html;charset=UTF-8";
    public static final String TEXT_HTML_CONTENT_TYPE_WITH_ISO_8859_1_CHARSET = "text/html;charset=ISO-8859-1";
    public static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"), "ahc-tests-" + UUID.randomUUID().toString().substring(0, 8));
    private static final byte[] PATTERN_BYTES = "FooBarBazQixFooBarBazQixFooBarBazQixFooBarBazQixFooBarBazQixFooBarBazQix".getBytes(Charset.forName("UTF-16"));
    public static final File LARGE_IMAGE_FILE;
    public static final byte[] LARGE_IMAGE_BYTES;
    public static final String LARGE_IMAGE_BYTES_MD5;
    public static final File SIMPLE_TEXT_FILE;
    public static final String SIMPLE_TEXT_FILE_STRING;
    private static final LoginService LOGIN_SERVICE;

    public static synchronized int findFreePort() throws IOException {
        try (ServerSocket socket = ServerSocketFactory.getDefault().createServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static File resourceAsFile(String path) throws URISyntaxException, IOException {
        ClassLoader cl = TestUtils.class.getClassLoader();
        URI uri = cl.getResource(path).toURI();
        if (uri.isAbsolute() && !uri.isOpaque()) {
            return new File(uri);
        }
        File tmpFile = File.createTempFile("tmpfile-", ".data", TMP_DIR);
        tmpFile.deleteOnExit();
        try (InputStream is = cl.getResourceAsStream(path);){
            FileUtils.copyInputStreamToFile((InputStream)is, (File)tmpFile);
            File file = tmpFile;
            return file;
        }
    }

    public static File createTempFile(int approxSize) throws IOException {
        long repeats = approxSize / PATTERN_BYTES.length + 1;
        File tmpFile = File.createTempFile("tmpfile-", ".data", TMP_DIR);
        tmpFile.deleteOnExit();
        try (OutputStream out = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);){
            int i = 0;
            while ((long)i < repeats) {
                out.write(PATTERN_BYTES);
                ++i;
            }
            long expectedFileSize = (long)PATTERN_BYTES.length * repeats;
            Assert.assertEquals((long)tmpFile.length(), (long)expectedFileSize, (String)"Invalid file length");
            File file = tmpFile;
            return file;
        }
    }

    public static ServerConnector addHttpConnector(Server server) {
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        return connector;
    }

    public static ServerConnector addHttpsConnector(Server server) throws IOException, URISyntaxException {
        String keyStoreFile = TestUtils.resourceAsFile("ssltest-keystore.jks").getAbsolutePath();
        SslContextFactory sslContextFactory = new SslContextFactory(keyStoreFile);
        sslContextFactory.setKeyStorePassword("changeit");
        String trustStoreFile = TestUtils.resourceAsFile("ssltest-cacerts.jks").getAbsolutePath();
        sslContextFactory.setTrustStorePath(trustStoreFile);
        sslContextFactory.setTrustStorePassword("changeit");
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.setSecureScheme("https");
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfig)});
        server.addConnector((Connector)connector);
        return connector;
    }

    public static void addBasicAuthHandler(Server server, Handler handler) {
        TestUtils.addAuthHandler(server, "BASIC", (LoginAuthenticator)new BasicAuthenticator(), handler);
    }

    public static void addDigestAuthHandler(Server server, Handler handler) {
        TestUtils.addAuthHandler(server, "DIGEST", (LoginAuthenticator)new DigestAuthenticator(), handler);
    }

    private static void addAuthHandler(Server server, String auth, LoginAuthenticator authenticator, Handler handler) {
        server.addBean((Object)LOGIN_SERVICE);
        Constraint constraint = new Constraint();
        constraint.setName(auth);
        constraint.setRoles(new String[]{USER, ADMIN});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        HashSet<String> knownRoles = new HashSet<String>();
        knownRoles.add(USER);
        knownRoles.add(ADMIN);
        ArrayList<ConstraintMapping> cm = new ArrayList<ConstraintMapping>();
        cm.add(mapping);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        security.setConstraintMappings(cm, knownRoles);
        security.setAuthenticator((Authenticator)authenticator);
        security.setLoginService(LOGIN_SERVICE);
        security.setHandler(handler);
        server.setHandler((Handler)security);
    }

    private static KeyManager[] createKeyManagers() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        try (InputStream keyStoreStream = TestUtils.class.getClassLoader().getResourceAsStream("ssltest-cacerts.jks");){
            char[] keyStorePassword = "changeit".toCharArray();
            ks.load(keyStoreStream, keyStorePassword);
        }
        assert (ks.size() > 0);
        char[] certificatePassword = "changeit".toCharArray();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, certificatePassword);
        return kmf.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        try (InputStream keyStoreStream = TestUtils.class.getClassLoader().getResourceAsStream("ssltest-keystore.jks");){
            char[] keyStorePassword = "changeit".toCharArray();
            ks.load(keyStoreStream, keyStorePassword);
        }
        assert (ks.size() > 0);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        return tmf.getTrustManagers();
    }

    public static SslEngineFactory createSslEngineFactory() {
        return TestUtils.createSslEngineFactory(new AtomicBoolean(true));
    }

    public static SslEngineFactory createSslEngineFactory(AtomicBoolean trust) {
        try {
            KeyManager[] keyManagers = TestUtils.createKeyManagers();
            TrustManager[] trustManagers = new TrustManager[]{TestUtils.dummyTrustManager(trust, (X509TrustManager)TestUtils.createTrustManagers()[0])};
            SecureRandom secureRandom = new SecureRandom();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, secureRandom);
            return new JsseSslEngineFactory(sslContext);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static TrustManager dummyTrustManager(AtomicBoolean trust, X509TrustManager tm) {
        return new DummyTrustManager(trust, tm);
    }

    public static File getClasspathFile(String file) throws FileNotFoundException {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = TestUtils.class.getClassLoader();
        }
        URL resourceUrl = cl.getResource(file);
        try {
            return new File(new URI(resourceUrl.toString()).getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException(file);
        }
    }

    public static void assertContentTypesEquals(String actual, String expected) {
        Assert.assertEquals((String)actual.replace("; ", "").toLowerCase(Locale.ENGLISH), (String)expected.replace("; ", "").toLowerCase(Locale.ENGLISH), (String)"Unexpected content-type");
    }

    public static void writeResponseBody(HttpServletResponse response, String body) {
        response.setContentLength(body.length());
        try {
            response.getOutputStream().print(body);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5(byte[] bytes) {
        return TestUtils.md5(bytes, 0, bytes.length);
    }

    public static String md5(byte[] bytes, int offset, int len) {
        try {
            MessageDigest md = MessageDigestUtils.pooledMd5MessageDigest();
            md.update(bytes, offset, len);
            return Base64.getEncoder().encodeToString(md.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LOGIN_SERVICE = new HashLoginService("MyRealm", "src/test/resources/realm.properties");
        try {
            TMP_DIR.mkdirs();
            TMP_DIR.deleteOnExit();
            LARGE_IMAGE_FILE = TestUtils.resourceAsFile("300k.png");
            LARGE_IMAGE_BYTES = FileUtils.readFileToByteArray((File)LARGE_IMAGE_FILE);
            LARGE_IMAGE_BYTES_MD5 = TestUtils.md5(LARGE_IMAGE_BYTES);
            SIMPLE_TEXT_FILE = TestUtils.resourceAsFile("SimpleTextFile.txt");
            SIMPLE_TEXT_FILE_STRING = FileUtils.readFileToString((File)SIMPLE_TEXT_FILE, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class AsyncHandlerAdapter
    implements AsyncHandler<String> {
        public void onThrowable(Throwable t) {
            Assert.fail((String)"Unexpected exception", (Throwable)t);
        }

        public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
            return AsyncHandler.State.CONTINUE;
        }

        public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
            return AsyncHandler.State.CONTINUE;
        }

        public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
            return AsyncHandler.State.CONTINUE;
        }

        public String onCompleted() throws Exception {
            return "";
        }
    }

    public static class AsyncCompletionHandlerAdapter
    extends AsyncCompletionHandler<Response> {
        public Response onCompleted(Response response) throws Exception {
            return response;
        }

        public void onThrowable(Throwable t) {
            Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
        }
    }

    public static class DummyTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private final AtomicBoolean trust;

        DummyTrustManager(AtomicBoolean trust, X509TrustManager tm) {
            this.trust = trust;
            this.tm = tm;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.tm.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (!this.trust.get()) {
                throw new CertificateException("Server certificate not trusted.");
            }
            this.tm.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }
    }
}

