/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoWebSocket
extends WebSocketAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoWebSocket.class);

    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        sess.setIdleTimeout(10000L);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.getSession().close();
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        if (this.isNotConnected()) {
            return;
        }
        try {
            LOGGER.debug("Received binary frame of size {}: {}", (Object)len, (Object)new String(payload, offset, len, StandardCharsets.UTF_8));
            this.getRemote().sendBytes(ByteBuffer.wrap(payload, offset, len));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onWebSocketText(String message) {
        if (this.isNotConnected()) {
            return;
        }
        if (message.equals("CLOSE")) {
            this.getSession().close();
            return;
        }
        try {
            LOGGER.debug("Received text frame of size: {}", (Object)message);
            this.getRemote().sendString(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

