/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.test.TestUtils;
import org.asynchttpclient.ws.AbstractBasicWebSocketTest;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class ProxyTunnellingTest
extends AbstractBasicWebSocketTest {
    private Server server2;

    private void setUpServers(boolean targetHttps) throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        this.server.setHandler((Handler)new ConnectHandler());
        this.server.start();
        this.port1 = connector.getLocalPort();
        this.server2 = new Server();
        ServerConnector connector2 = targetHttps ? TestUtils.addHttpsConnector(this.server2) : TestUtils.addHttpConnector(this.server2);
        this.server2.setHandler((Handler)this.configureHandler());
        this.server2.start();
        this.port2 = connector2.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.server.stop();
        this.server2.stop();
    }

    @Test(timeOut=60000L)
    public void echoWSText() throws Exception {
        this.runTest(false);
    }

    @Test(timeOut=60000L)
    public void echoWSSText() throws Exception {
        this.runTest(true);
    }

    private void runTest(boolean secure) throws Exception {
        this.setUpServers(secure);
        String targetUrl = String.format("%s://localhost:%d/", secure ? "wss" : "ws", this.port2);
        ProxyServer ps = Dsl.proxyServer((String)"localhost", (int)this.port1).build();
        try (AsyncHttpClient asyncHttpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setProxyServer(ps).setUseInsecureTrustManager(true));){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)asyncHttpClient.prepareGet(targetUrl).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    text.set(payload);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendTextFrame("ECHO");
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHO");
        }
    }
}

