/*
 * Decompiled with CFR 0.152.
 */
package org.webtide.demo.auction;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.Seti;
import org.cometd.oort.SetiServlet;
import org.cometd.server.AbstractService;
import org.webtide.demo.auction.Bid;
import org.webtide.demo.auction.Bidder;
import org.webtide.demo.auction.Category;
import org.webtide.demo.auction.Item;
import org.webtide.demo.auction.dao.AuctionDao;
import org.webtide.demo.auction.dao.BidderDao;
import org.webtide.demo.auction.dao.CategoryDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuctionService
extends AbstractService
implements ClientSessionChannel.MessageListener,
BayeuxServer.ChannelListener,
BayeuxServer.SubscriptionListener {
    public static final String AUCTION_ROOT = "/auction/";
    private final AuctionDao _auctionDao = new AuctionDao();
    private final BidderDao _bidderDao = new BidderDao();
    private final CategoryDao _categoryDao = new CategoryDao();
    private final AtomicInteger _bidders = new AtomicInteger(0);
    private Oort _oort;
    private Seti _seti;

    public AuctionService(ServletContext context) {
        super((BayeuxServer)context.getAttribute("org.cometd.bayeux"), "oortion");
        this._oort = (Oort)context.getAttribute(Oort.OORT_ATTRIBUTE);
        if (this._oort == null) {
            throw new RuntimeException("Missing " + Oort.OORT_ATTRIBUTE + " from " + ServletContext.class.getSimpleName() + "; " + "is an Oort servlet declared in web.xml ?");
        }
        this._seti = (Seti)context.getAttribute(Seti.SETI_ATTRIBUTE);
        if (this._seti == null) {
            throw new RuntimeException("Missing " + Seti.SETI_ATTRIBUTE + " from " + ServletContext.class.getSimpleName() + "; " + "is " + SetiServlet.class.getSimpleName() + " declared in web.xml ?");
        }
        this._oort.observeChannel("/auction/**");
        this.getBayeux().addListener((BayeuxServer.BayeuxServerListener)this);
        this.setSeeOwnPublishes(false);
        this.getBayeux().createIfAbsent("/service/auction/*", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */});
        this.getBayeux().createIfAbsent("/auction/*", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */});
        this.addService("/auction/*", "bids");
        this.addService("/service/auction/bid", "bid");
        this.addService("/service/auction/bidder", "bidder");
        this.addService("/service/auction/search", "search");
        this.addService("/service/auction/category", "category");
        this.addService("/service/auction/categories", "categories");
    }

    public Bidder bidder(ServerSession source, String channel, String bidder, String messageId) {
        Integer id = this._bidders.incrementAndGet();
        String username = bidder.toLowerCase().replace(" ", "");
        while (this._bidderDao.getBidder(username) != null) {
            username = bidder.toLowerCase().replace(" ", "") + "-" + this._bidders.incrementAndGet();
        }
        Bidder b = new Bidder();
        b.setName(bidder);
        b.setUsername(username);
        this._bidderDao.addBidder(b);
        this._seti.associate(b.getUsername(), source);
        return b;
    }

    public List<Category> categories(ServerSession source, String channel, String bidder, String messageId) {
        return this._categoryDao.getAllCategories();
    }

    public List<Item> search(ServerSession source, String channel, String search, String messageId) {
        return this._categoryDao.findItems(search);
    }

    public List<Item> category(ServerSession source, String channel, Number categoryId, String messageId) {
        return this._categoryDao.getItemsInCategory(Integer.valueOf(categoryId.intValue()));
    }

    public synchronized void bid(ServerSession source, String channel, Map<String, Object> bidMap, String messageId) {
        try {
            Bid highest;
            Integer itemId = ((Number)bidMap.get("itemId")).intValue();
            Double amount = Double.parseDouble(bidMap.get("amount").toString());
            String username = (String)bidMap.get("username");
            Bidder bidder = this._bidderDao.getBidder(username);
            if (bidder != null && ((highest = this._auctionDao.getHighestBid(itemId)) == null || amount > highest.getAmount())) {
                Bid bid = new Bid();
                bid.setItemId(itemId);
                bid.setAmount(amount);
                bid.setBidder(bidder);
                this._auctionDao.saveAuctionBid(bid);
                this.getBayeux().getChannel("/auction/item" + itemId).publish((Session)this.getServerSession(), (Object)bid, messageId);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public synchronized void bids(ServerSession source, String channel, Map<String, Object> bidMap, String messageId) {
        Integer itemId = ((Number)bidMap.get("itemId")).intValue();
        Double amount = Double.parseDouble(bidMap.get("amount").toString());
        Map bidderMap = (Map)bidMap.get("bidder");
        String username = (String)bidderMap.get("username");
        Bidder bidder = this._bidderDao.getBidder(username);
        if (bidder == null) {
            bidder = new Bidder();
            bidder.setUsername(username);
            bidder.setName((String)bidderMap.get("name"));
            this._bidderDao.addBidder(bidder);
            bidder = this._bidderDao.getBidder(username);
        }
        Bid bid = new Bid();
        bid.setItemId(itemId);
        bid.setAmount(amount);
        bid.setBidder(bidder);
        Bid highest = this._auctionDao.getHighestBid(itemId);
        if (highest == null || amount > highest.getAmount()) {
            this._auctionDao.saveAuctionBid(bid);
        }
    }

    public void subscribed(ServerSession session, ServerChannel channel) {
        Integer itemId;
        Bid highest;
        String itemIdS;
        if (!session.isLocalSession() && channel.getId().startsWith("/auction/item") && (itemIdS = channel.getId().substring("/auction/item".length())).indexOf(47) < 0 && (highest = this._auctionDao.getHighestBid(itemId = Integer.decode(itemIdS))) != null) {
            session.deliver((Session)this.getServerSession(), channel.getId(), (Object)highest, null);
        }
    }

    public void unsubscribed(ServerSession session, ServerChannel channel) {
    }

    public void channelAdded(ServerChannel channel) {
        if (channel.getId().startsWith("/auction/item")) {
            this.getLocalSession().getChannel(channel.getId()).subscribe((ClientSessionChannel.MessageListener)this);
        }
    }

    public void channelRemoved(String channelId) {
    }

    public void onMessage(ClientSessionChannel channel, Message message) {
    }

    public void configureChannel(ConfigurableServerChannel channel) {
    }
}

