/*
 * Decompiled with CFR 0.152.
 */
package org.webtide.demo.auction.dao;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.webtide.demo.auction.Bid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuctionDao {
    static final ConcurrentMap<Integer, List<Bid>> _bids = new ConcurrentHashMap();

    public List<Bid> getAllBids(Integer itemId) {
        return (List)_bids.get(itemId);
    }

    public void saveAuctionBid(Bid bid) {
        CopyOnWriteArrayList<Bid> bids = (CopyOnWriteArrayList<Bid>)_bids.get(bid.getItemId());
        if (bids == null) {
            bids = new CopyOnWriteArrayList<Bid>();
            List tmp = _bids.putIfAbsent(bid.getItemId(), bids);
            bids = tmp == null ? bids : tmp;
        }
        bids.add(bid.clone());
    }

    public Bid getHighestBid(Integer itemId) {
        List bids = (List)_bids.get(itemId);
        if (bids == null) {
            return null;
        }
        Bid highest = null;
        for (Bid bid : bids) {
            if (highest != null && !(bid.getAmount() > highest.getAmount())) continue;
            highest = bid;
        }
        return highest.clone();
    }
}

