/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.rpc.server.RPC;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.gwt.server.GwtResponseWriter;
import org.atmosphere.gwt.server.deflate.DeflaterOutputStream;
import org.atmosphere.gwt.server.impl.GwtAtmosphereResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GwtResponseWriterImpl
implements GwtResponseWriter {
    protected Writer writer;
    protected final GwtAtmosphereResourceImpl resource;
    protected final int connectionID;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SerializationPolicy serializationPolicy;
    private final ClientOracle clientOracle;
    private boolean terminated;
    private volatile long lastWriteTime;
    private ScheduledFuture<?> heartbeatFuture;
    private static AtomicInteger connectionIDs = new AtomicInteger(1);

    protected GwtResponseWriterImpl(GwtAtmosphereResourceImpl resource, SerializationPolicy serializationPolicy, ClientOracle clientOracle) {
        this.resource = resource;
        this.serializationPolicy = serializationPolicy;
        this.clientOracle = clientOracle;
        this.connectionID = connectionIDs.getAndIncrement();
    }

    @Override
    public synchronized boolean isTerminated() {
        return this.terminated;
    }

    protected boolean isDeRPC() {
        return this.clientOracle != null;
    }

    public HttpServletRequest getRequest() {
        return this.resource.getAtmosphereResource().getRequest();
    }

    public HttpServletResponse getResponse() {
        return this.resource.getAtmosphereResource().getResponse();
    }

    synchronized void scheduleHeartbeat() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Schedule heartbeat for [" + this.connectionID + "]");
            this.logger.trace("Last write for [" + this.connectionID + "] was " + new Date(this.lastWriteTime).toString());
        }
        this.lastWriteTime = System.currentTimeMillis();
        if (this.heartbeatFuture != null) {
            this.heartbeatFuture.cancel(false);
        }
        this.heartbeatFuture = this.resource.scheduleHeartbeat();
    }

    @Override
    public void sendError(int statusCode) throws IOException {
        this.sendError(statusCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendError(int statusCode, String message) throws IOException {
        try {
            if (this.writer == null) {
                this.getResponse().reset();
                this.getResponse().setHeader("Cache-Control", "no-cache");
                this.getResponse().setCharacterEncoding("UTF-8");
                this.writer = new OutputStreamWriter((OutputStream)this.getResponse().getOutputStream(), "UTF-8");
            }
            this.doSendError(statusCode, message);
        }
        catch (IllegalStateException e) {
            this.logger.error("Error resetting response to send error: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.debug("Failed to send error to client", (Throwable)e);
        }
        finally {
            this.setTerminated(true);
        }
    }

    protected OutputStream getOutputStream(OutputStream outputStream) {
        return outputStream;
    }

    public synchronized void initiate() throws IOException {
        this.getResponse().setHeader("Cache-Control", "no-cache");
        this.getResponse().setCharacterEncoding("UTF-8");
        Object outputStream = this.getResponse().getOutputStream();
        outputStream = this.getOutputStream((OutputStream)outputStream);
        String acceptEncoding = this.getRequest().getHeader("Accept-Encoding");
        if (acceptEncoding != null && acceptEncoding.contains("deflate")) {
            this.getResponse().setHeader("Content-Encoding", "deflate");
            outputStream = new DeflaterOutputStream((OutputStream)outputStream);
        }
        this.writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Initiated [" + this.connectionID + "]");
        }
        this.getRequest().setAttribute("connectionID", (Object)this.connectionID);
        this.scheduleHeartbeat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws IOException {
        try {
            GwtResponseWriterImpl gwtResponseWriterImpl = this;
            synchronized (gwtResponseWriterImpl) {
                if (this.terminated) {
                    return;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Suspending [" + this.connectionID + "]");
                }
                this.doSuspend();
                this.flush();
            }
        }
        catch (IOException e) {
            this.logger.error("Error suspending response", (Throwable)e);
            GwtResponseWriterImpl gwtResponseWriterImpl = this;
            synchronized (gwtResponseWriterImpl) {
                this.setTerminated(false);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void terminate() throws IOException {
        if (!this.terminated) {
            try {
                this.doTerminate();
                this.flush();
            }
            finally {
                this.setTerminated(true);
            }
        }
    }

    void tryTerminate() {
        try {
            this.terminate();
        }
        catch (IOException e) {
            this.logger.error("Error terminating response", (Throwable)e);
        }
    }

    @Override
    public void write(Serializable message) throws IOException {
        this.write(Collections.singletonList(message), true);
    }

    @Override
    public void write(Serializable message, boolean flush) throws IOException {
        this.write(Collections.singletonList(message), flush);
    }

    @Override
    public void write(List<? extends Serializable> messages) throws IOException {
        this.write(messages, true);
    }

    @Override
    public synchronized void write(List<? extends Serializable> messages, boolean flush) throws IOException {
        if (this.terminated) {
            throw new IOException("CometServletResponse terminated");
        }
        try {
            if (messages.size() == 1 && messages.get(0) instanceof String && messages.get(0).equals("4dc5bdb9-edc8-4edf-8833-ab478326d8c9")) {
                this.heartbeat();
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Writing #" + messages.size() + " messages to [" + this.connectionID + "]");
                }
                this.doWrite(messages);
                if (flush) {
                    this.flush();
                }
                this.scheduleHeartbeat();
            }
        }
        catch (IOException e) {
            this.resource.resumeAfterDeath();
            this.setTerminated(false);
            throw e;
        }
    }

    @Override
    public synchronized void heartbeat() throws IOException {
        if (!this.terminated) {
            try {
                this.logger.trace("Sending heartbeat [" + this.connectionID + "]");
                this.doHeartbeat();
                this.flush();
                this.scheduleHeartbeat();
            }
            catch (IOException e) {
                this.logger.debug("Failed to send heartbeat", (Throwable)e);
                this.setTerminated(false);
                throw e;
            }
        }
    }

    synchronized void flush() throws IOException {
        this.writer.flush();
    }

    synchronized void setTerminated(boolean serverInitiated) {
        if (!this.terminated) {
            this.terminated = true;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Terminating [" + this.connectionID + "]");
            }
            if (this.heartbeatFuture != null) {
                this.heartbeatFuture.cancel(false);
                this.heartbeatFuture = null;
            }
            if (serverInitiated) {
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error("Error closing connection", (Throwable)e);
                }
                this.resource.terminate(serverInitiated);
            }
        }
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    protected abstract void doSendError(int var1, String var2) throws IOException;

    protected abstract void doSuspend() throws IOException;

    protected abstract void doWrite(List<? extends Serializable> var1) throws IOException;

    protected abstract void doHeartbeat() throws IOException;

    protected abstract void doTerminate() throws IOException;

    protected boolean hasSession() {
        HttpSession session = this.resource.getSession(false);
        return session != null;
    }

    protected String serialize(Serializable message) throws NotSerializableException, UnsupportedEncodingException {
        try {
            if (this.clientOracle == null) {
                ServerSerializationStreamWriter streamWriter = new ServerSerializationStreamWriter(this.serializationPolicy);
                streamWriter.prepareToWrite();
                streamWriter.writeObject((Object)message);
                return streamWriter.toString();
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            RPC.streamResponseForSuccess((ClientOracle)this.clientOracle, (OutputStream)result, (Object)message);
            return new String(result.toByteArray(), "UTF-8");
        }
        catch (SerializationException e) {
            throw new NotSerializableException("Unable to serialize object, message: " + e.getMessage());
        }
    }
}

