/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.gwt.server.GwtAtmosphereResource;
import org.atmosphere.gwt.server.impl.GwtAtmosphereResourceImpl;
import org.atmosphere.gwt.server.impl.RPCUtil;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereGwtHandler
extends AbstractReflectorAtmosphereHandler
implements Executor,
AtmosphereServletProcessor {
    public static final int NO_TIMEOUT = -1;
    public static final String GWT_BROADCASTER_ID = "GWT_BROADCASTER";
    private static final int DEFAULT_HEARTBEAT = 15000;
    private ExecutorService executorService;
    private int heartbeat = 15000;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    protected SerializationPolicyProvider cometSerializationPolicyProvider = new SerializationPolicyProvider(){

        public SerializationPolicy getSerializationPolicy(String moduleBaseURL, String serializationPolicyStrongName) {
            return RPCUtil.createSimpleSerializationPolicy();
        }
    };
    private Map<Integer, GwtAtmosphereResource> resources;
    private ServletContext context;

    public int doComet(GwtAtmosphereResource resource) throws ServletException, IOException {
        Broadcaster broadcaster = BroadcasterFactory.getDefault().lookup(Broadcaster.class, (Object)GWT_BROADCASTER_ID);
        if (broadcaster == null) {
            broadcaster = BroadcasterFactory.getDefault().get(DefaultBroadcaster.class, (Object)GWT_BROADCASTER_ID);
        }
        resource.getAtmosphereResource().setBroadcaster(broadcaster);
        return -1;
    }

    public void cometTerminated(GwtAtmosphereResource cometResponse, boolean serverInitiated) {
        this.resources.remove(cometResponse.getConnectionID());
    }

    public void doPost(HttpServletRequest postRequest, HttpServletResponse postResponse, List<Serializable> messages, GwtAtmosphereResource cometResource) {
        if (cometResource != null && cometResource.isAlive()) {
            if (messages.size() == 1) {
                cometResource.post(messages.get(0));
            } else {
                cometResource.post(messages);
            }
        }
    }

    @Deprecated
    protected Broadcaster getBroadcaster(GwtAtmosphereResource resource) {
        return resource.getBroadcaster();
    }

    protected GwtAtmosphereResource lookupResource(int connectionId) {
        GwtAtmosphereResource r = this.resources.get(connectionId);
        if (r != null) {
            return r;
        }
        this.logger.info("Failed to find resource for [" + connectionId + "]");
        return null;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.executorService = Executors.newCachedThreadPool();
        String heartbeat = servletConfig.getInitParameter("heartbeat");
        this.context = servletConfig.getServletContext();
        if (heartbeat != null) {
            this.heartbeat = Integer.parseInt(heartbeat);
        }
    }

    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    protected void reapResources() {
        if (this.resources != null) {
            for (GwtAtmosphereResource resource : this.resources.values()) {
                if (resource.isAlive()) continue;
                this.resources.remove(resource.getConnectionID());
            }
        }
    }

    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> resource) throws IOException {
        HttpServletRequest request = (HttpServletRequest)resource.getRequest();
        String servertransport = request.getParameter("servertransport");
        if ("rpcprotocol".equals(servertransport)) {
            Integer connectionID = Integer.parseInt(request.getParameter("connectionID"));
            this.doServerMessage(request, (HttpServletResponse)resource.getResponse(), connectionID);
            return;
        }
        try {
            int requestHeartbeat = this.heartbeat;
            String requestedHeartbeat = request.getParameter("heartbeat");
            if (requestedHeartbeat != null) {
                try {
                    requestHeartbeat = Integer.parseInt(requestedHeartbeat);
                    if (requestHeartbeat <= 0) {
                        throw new IOException("invalid heartbeat parameter");
                    }
                    requestHeartbeat = this.computeHeartbeat(requestHeartbeat);
                }
                catch (NumberFormatException e) {
                    throw new IOException("invalid heartbeat parameter");
                }
            }
            GwtAtmosphereResourceImpl resourceWrapper = new GwtAtmosphereResourceImpl(resource, this, requestHeartbeat);
            this.doCometImpl(resourceWrapper);
        }
        catch (IOException e) {
            this.logger.error("Unable to initiated comet" + e.getMessage(), (Throwable)e);
        }
    }

    protected void doServerMessage(HttpServletRequest request, HttpServletResponse response, int connectionID) throws IOException {
        BufferedReader data = request.getReader();
        ArrayList<Serializable> postMessages = new ArrayList<Serializable>();
        GwtAtmosphereResource resource = this.lookupResource(connectionID);
        if (resource == null || !resource.isAlive()) {
            return;
        }
        try {
            String messageData;
            String event;
            while ((event = data.readLine()) != null && (messageData = data.readLine()) != null) {
                Object message;
                data.readLine();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[" + connectionID + "] Server message received: " + event + ";" + messageData.charAt(0));
                }
                if (event.equals("o")) {
                    if (messageData.charAt(0) == 'p') {
                        message = this.deserialize(messageData.substring(1));
                        if (message == null) continue;
                        postMessages.add((Serializable)message);
                        continue;
                    }
                    if (messageData.charAt(0) != 'b') continue;
                    message = this.deserialize(messageData.substring(1));
                    this.broadcast((Serializable)message, resource);
                    continue;
                }
                if (event.equals("s")) {
                    if (messageData.charAt(0) == 'p') {
                        message = messageData.substring(1);
                        postMessages.add((Serializable)message);
                        continue;
                    }
                    if (messageData.charAt(0) != 'b') continue;
                    message = messageData.substring(1);
                    this.broadcast((Serializable)message, resource);
                    continue;
                }
                if (!event.equals("c") || !messageData.equals("d")) continue;
                this.disconnect(resource);
            }
        }
        catch (IOException ex) {
            this.logger.error("[" + connectionID + "] Failed to read", (Throwable)ex);
        }
        if (postMessages.size() > 0) {
            this.post(request, response, postMessages, resource);
        }
    }

    protected Serializable deserialize(String data) {
        try {
            ServerSerializationStreamReader reader = new ServerSerializationStreamReader(this.getClass().getClassLoader(), this.cometSerializationPolicyProvider);
            reader.prepareToRead(data);
            return (Serializable)reader.readObject();
        }
        catch (SerializationException ex) {
            this.logger.error("Failed to deserialize message", (Throwable)ex);
            return null;
        }
    }

    public final void post(HttpServletRequest postRequest, HttpServletResponse postResponse, List<Serializable> messages, GwtAtmosphereResource cometResource) {
        if (messages == null) {
            return;
        }
        this.doPost(postRequest, postResponse, messages, cometResource);
    }

    public void broadcast(Serializable message, GwtAtmosphereResource resource) {
        if (message == null) {
            return;
        }
        if (resource.isAlive()) {
            resource.getBroadcaster().broadcast((Object)message);
        }
    }

    public void broadcast(List<Serializable> messages, GwtAtmosphereResource resource) {
        if (messages == null) {
            return;
        }
        if (resource.isAlive()) {
            resource.getBroadcaster().broadcast(messages);
        }
    }

    public void disconnect(GwtAtmosphereResource resource) {
        if (resource != null) {
            this.logger.debug("Resuming connection[" + resource.getConnectionID() + "] after client disconnect message");
            resource.getAtmosphereResource().resume();
        }
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    protected int computeHeartbeat(int requestedHeartbeat) {
        return requestedHeartbeat < this.heartbeat ? this.heartbeat : requestedHeartbeat;
    }

    private void doCometImpl(GwtAtmosphereResourceImpl resource) throws IOException {
        int timeout;
        try {
            resource.getWriterImpl().initiate();
            if (this.resources == null) {
                this.resources = new ConcurrentHashMap<Integer, GwtAtmosphereResource>(5);
                this.scheduler.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        AtmosphereGwtHandler.this.reapResources();
                    }
                }, 30L, 10L, TimeUnit.SECONDS);
            }
            this.resources.put(resource.getConnectionID(), resource);
        }
        catch (IOException e) {
            this.logger.error("Error initiating GwtComet", (Throwable)e);
            return;
        }
        try {
            timeout = this.doComet(resource);
            if (timeout == -1) {
                this.logger.info("You have set an infinite timeout for your comet connection this is not recommended");
            }
        }
        catch (ServletException e) {
            this.logger.error("Error calling doComet()", (Throwable)e);
            return;
        }
        catch (IOException e) {
            this.logger.error("Error calling doComet()", (Throwable)e);
            return;
        }
        resource.suspend(timeout);
    }
}

