/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.rpc.server.HostedModeClientOracle;
import com.google.gwt.rpc.server.WebModeClientOracle;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class RPCUtil {
    protected static final String CLIENT_ORACLE_EXTENSION = ".gwt.rpc";
    private static final Map<String, SoftReference<ClientOracle>> clientOracleCache = new HashMap<String, SoftReference<ClientOracle>>();
    private static SerializationPolicy policy;

    public static SerializationPolicy createSimpleSerializationPolicy() {
        if (policy != null) {
            return policy;
        }
        policy = new SerializationPolicy(){

            public boolean shouldDeserializeFields(Class<?> clazz) {
                return Object.class != clazz;
            }

            public boolean shouldSerializeFields(Class<?> clazz) {
                return Object.class != clazz;
            }

            public void validateDeserialize(Class<?> clazz) {
            }

            public void validateSerialize(Class<?> clazz) {
            }
        };
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ClientOracle getClientOracle(HttpServletRequest request, ServletContext context) throws IOException {
        ClientOracle toReturn;
        String permutationStrongName = request.getParameter("p");
        if (permutationStrongName == null) {
            return null;
        }
        Map<String, SoftReference<ClientOracle>> map = clientOracleCache;
        synchronized (map) {
            if (clientOracleCache.containsKey(permutationStrongName) && (toReturn = clientOracleCache.get(permutationStrongName).get()) != null) {
                return toReturn;
            }
            if ("HostedMode".equals(permutationStrongName)) {
                toReturn = new HostedModeClientOracle();
            } else {
                String moduleBase = request.getParameter("b");
                if (moduleBase == null) {
                    return null;
                }
                String basePath = new URL(moduleBase).getPath();
                if (basePath == null) {
                    throw new MalformedURLException("Blocked request without GWT base path parameter (XSRF attack?)");
                }
                String contextPath = context.getContextPath();
                if (!basePath.startsWith(contextPath)) {
                    throw new MalformedURLException("Blocked request with invalid GWT base path parameter (XSRF attack?)");
                }
                basePath = basePath.substring(contextPath.length());
                InputStream in = RPCUtil.findClientOracleData(basePath, permutationStrongName, context);
                toReturn = WebModeClientOracle.load((InputStream)in);
            }
            clientOracleCache.put(permutationStrongName, new SoftReference<ClientOracle>(toReturn));
        }
        return toReturn;
    }

    private static InputStream findClientOracleData(String requestModuleBasePath, String permutationStrongName, ServletContext context) throws IOException {
        String resourcePath = requestModuleBasePath + permutationStrongName + CLIENT_ORACLE_EXTENSION;
        InputStream in = context.getResourceAsStream(resourcePath);
        if (in == null) {
            throw new IOException("Could not find ClientOracle data for permutation " + permutationStrongName);
        }
        return in;
    }
}

