/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.atmosphere.gwt.server.SerializationException;
import org.atmosphere.gwt.server.impl.GwtAtmosphereResourceImpl;
import org.atmosphere.gwt.server.impl.ManagedStreamResponseWriter;

public class IFrameResponseWriter
extends ManagedStreamResponseWriter {
    private static final int PADDING_REQUIRED = 256;
    private static final String HEAD = "<html><body onload='parent.d()'><script>";
    private static final String MID = "parent.c(";
    private static final String TAIL = ");var m=parent.m;var h=parent.h;</script>";
    private static final String PADDING_STRING;

    public IFrameResponseWriter(GwtAtmosphereResourceImpl resource) {
        super(resource);
    }

    @Override
    public void initiate() throws IOException {
        this.getResponse().setContentType("text/html");
        String origin = this.getRequest().getHeader("Origin");
        if (origin != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Origin: " + origin);
            }
            this.getResponse().setHeader("Access-Control-Allow-Origin", origin);
        }
        super.initiate();
        this.writer.append(HEAD);
        String domain = this.getRequest().getParameter("d");
        if (domain != null) {
            this.writer.append("document.domain='");
            this.writer.append(domain);
            this.writer.append("';");
        }
        this.writer.append(MID);
        this.writer.append(Integer.toString(this.resource.getHeartBeatInterval()));
        this.writer.append(',').append(String.valueOf(this.connectionID));
        this.writer.append(TAIL);
    }

    @Override
    protected int getPaddingRequired() {
        return 256;
    }

    @Override
    protected CharSequence getPadding(int padding) {
        if (padding > PADDING_STRING.length()) {
            StringBuilder result = new StringBuilder(padding);
            for (int i = 0; i < padding; ++i) {
                result.append(' ');
            }
            return result;
        }
        return PADDING_STRING.substring(0, padding);
    }

    @Override
    protected void doSendError(int statusCode, String message) throws IOException {
        this.getResponse().setContentType("text/html");
        this.writer.append("<html><script>parent.e(").append(Integer.toString(statusCode));
        if (message != null) {
            this.writer.append(",'").append(this.escapeString(message)).append('\'');
        }
        this.writer.append(")</script></html>");
    }

    @Override
    protected void doWrite(List<? extends Serializable> messages) throws IOException, SerializationException {
        this.writer.append("<script>m(");
        boolean first = true;
        for (Serializable serializable : messages) {
            CharSequence string = serializable instanceof CharSequence ? "]" + this.escapeString((CharSequence)((Object)serializable)) : this.escapeObject(this.serialize(serializable));
            if (first) {
                first = false;
            } else {
                this.writer.append(',');
            }
            this.writer.append('\'').append(string).append('\'');
        }
        this.writer.append(")</script>");
    }

    @Override
    protected void doHeartbeat() throws IOException {
        this.writer.append("<script>h();</script>");
    }

    @Override
    protected void doTerminate() throws IOException {
        this.writer.append("<script>parent.t();</script>");
    }

    @Override
    protected void doRefresh() throws IOException {
        this.writer.append("<script>parent.r();</script>");
    }

    @Override
    protected boolean isOverRefreshLength(int written) {
        if (this.length != null) {
            return written > this.length;
        }
        return written > 0x400000;
    }

    private CharSequence escapeString(CharSequence string) {
        int i;
        if (!this.shouldEscapeText()) {
            return string;
        }
        int len = string != null ? string.length() : 0;
        block13: for (i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\b': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\'': 
                case '/': 
                case '\\': {
                    break block13;
                }
                default: {
                    continue block13;
                }
            }
        }
        if (i == len) {
            return string;
        }
        StringBuilder str = new StringBuilder(string.length() * 2);
        str.append(string, 0, i);
        while (i < len) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\'': {
                    str.append("\\'");
                    break;
                }
                case '\\': {
                    str.append("\\\\");
                    break;
                }
                case '/': {
                    str.append("\\/");
                    break;
                }
                case '\b': {
                    str.append("\\b");
                    break;
                }
                case '\f': {
                    str.append("\\f");
                    break;
                }
                case '\n': {
                    str.append("\\n");
                    break;
                }
                case '\r': {
                    str.append("\\r");
                    break;
                }
                case '\t': {
                    str.append("\\t");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str;
    }

    private CharSequence escapeObject(CharSequence string) {
        int i;
        if (!this.shouldEscapeText()) {
            return string;
        }
        int len = string != null ? string.length() : 0;
        block8: for (i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\'': 
                case '/': 
                case '\\': {
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        if (i == len) {
            return string;
        }
        StringBuilder str = new StringBuilder(string.length() * 2);
        str.append(string, 0, i);
        while (i < len) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\'': {
                    str.append("\\'");
                    break;
                }
                case '\\': {
                    str.append("\\\\");
                    break;
                }
                case '/': {
                    str.append("\\/");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str;
    }

    static {
        int capacity = 256 - HEAD.length() - MID.length() - TAIL.length();
        char[] padding = new char[capacity];
        for (int i = 0; i < capacity; ++i) {
            padding[i] = 32;
        }
        PADDING_STRING = new String(padding);
    }
}

