/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.gwt.server.GwtAtmosphereResource;
import org.atmosphere.gwt.server.JSONDeserializer;
import org.atmosphere.gwt.server.SerializationException;
import org.atmosphere.gwt.server.impl.GwtAtmosphereResourceImpl;
import org.atmosphere.gwt.server.impl.GwtRpcDeserializer;
import org.atmosphere.gwt.server.spi.JSONSerializerProvider;
import org.atmosphere.gwt.shared.SerialMode;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereGwtHandler
extends AbstractReflectorAtmosphereHandler
implements Executor,
AtmosphereServletProcessor {
    public static final int NO_TIMEOUT = -1;
    public static final String GWT_BROADCASTER_ID = "GWT_BROADCASTER";
    private static final int DEFAULT_HEARTBEAT = 15000;
    private ExecutorService executorService;
    private int heartbeat = 15000;
    private boolean escapeText = true;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private GwtRpcDeserializer gwtRpc;
    private JSONDeserializer jsonSerializer;
    private Map<Integer, GwtAtmosphereResource> resources;
    private ServletContext context;

    public int doComet(GwtAtmosphereResource resource) throws ServletException, IOException {
        Broadcaster broadcaster = BroadcasterFactory.getDefault().lookup(Broadcaster.class, (Object)GWT_BROADCASTER_ID);
        if (broadcaster == null) {
            broadcaster = BroadcasterFactory.getDefault().get(DefaultBroadcaster.class, (Object)GWT_BROADCASTER_ID);
        }
        resource.getAtmosphereResource().setBroadcaster(broadcaster);
        return -1;
    }

    public void cometTerminated(GwtAtmosphereResource cometResponse, boolean serverInitiated) {
    }

    public void doPost(HttpServletRequest postRequest, HttpServletResponse postResponse, List<?> messages, GwtAtmosphereResource cometResource) {
        if (cometResource != null) {
            if (messages.size() == 1) {
                cometResource.post(messages.get(0));
            } else {
                cometResource.post(messages);
            }
        }
    }

    protected GwtAtmosphereResource lookupResource(int connectionId) {
        if (this.resources == null) {
            return null;
        }
        GwtAtmosphereResource r = this.resources.get(connectionId);
        if (r != null) {
            return r;
        }
        this.logger.info("Failed to find resource for [" + connectionId + "]");
        return null;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        String escText;
        this.executorService = Executors.newCachedThreadPool();
        String heartbeat = servletConfig.getInitParameter("heartbeat");
        this.context = servletConfig.getServletContext();
        if (heartbeat != null) {
            this.heartbeat = Integer.parseInt(heartbeat);
        }
        if ((escText = servletConfig.getInitParameter("escapeText")) != null) {
            this.escapeText = Boolean.valueOf(escText);
        }
    }

    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public boolean isEscapeText() {
        return this.escapeText;
    }

    public void setEscapeText(boolean escapeText) {
        this.escapeText = escapeText;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    protected void reapResources() {
        if (this.resources != null) {
            for (GwtAtmosphereResource resource : this.resources.values()) {
                if (resource.isAlive()) continue;
                this.resources.remove(resource.getConnectionID());
            }
        }
    }

    public void onRequest(AtmosphereResource resource) throws IOException {
        AtmosphereRequest request = resource.getRequest();
        String servertransport = request.getParameter("servertransport");
        Object webSocketSubProtocol = resource.getRequest().getAttribute("websocket-subprotocol");
        if ("rpcprotocol".equals(servertransport)) {
            Integer connectionID = Integer.parseInt(request.getParameter("connectionID"));
            this.doServerMessage((HttpServletRequest)request, (HttpServletResponse)resource.getResponse(), connectionID);
            return;
        }
        if (webSocketSubProtocol != null && webSocketSubProtocol.equals("polling-websocket-message")) {
            Integer connectionID = (Integer)request.getAttribute(AtmosphereGwtHandler.class.getName() + ".connectionID");
            this.doServerMessage((HttpServletRequest)request, (HttpServletResponse)resource.getResponse(), connectionID);
            return;
        }
        try {
            int requestHeartbeat = this.getRequestedHeartbeat((HttpServletRequest)request);
            boolean requestEscapeText = this.getRequestedEscapeOfText((HttpServletRequest)request);
            GwtAtmosphereResourceImpl resourceWrapper = new GwtAtmosphereResourceImpl(resource, this, requestHeartbeat, requestEscapeText);
            request.setAttribute(AtmosphereGwtHandler.class.getName() + ".connectionID", (Object)resourceWrapper.getConnectionID());
            this.doCometImpl(resourceWrapper);
        }
        catch (IOException e) {
            this.logger.error("Unable to initiated comet" + e.getMessage(), (Throwable)e);
        }
    }

    private boolean getRequestedEscapeOfText(HttpServletRequest request) throws IOException {
        boolean requestEscapeText = this.escapeText;
        String requestedEscapeText = request.getParameter("escapeText");
        if (requestedEscapeText != null) {
            requestEscapeText = Boolean.valueOf(requestedEscapeText);
        }
        return requestEscapeText;
    }

    private int getRequestedHeartbeat(HttpServletRequest request) throws IOException {
        int requestHeartbeat = this.heartbeat;
        String requestedHeartbeat = request.getParameter("heartbeat");
        if (requestedHeartbeat != null) {
            try {
                requestHeartbeat = Integer.parseInt(requestedHeartbeat);
                if (requestHeartbeat <= 0) {
                    throw new IOException("invalid heartbeat parameter");
                }
                requestHeartbeat = this.computeHeartbeat(requestHeartbeat);
            }
            catch (NumberFormatException e) {
                throw new IOException("invalid heartbeat parameter");
            }
        }
        return requestHeartbeat;
    }

    protected void doServerMessage(HttpServletRequest request, HttpServletResponse response, int connectionID) throws IOException {
        BufferedReader data = request.getReader();
        ArrayList<Object> postMessages = new ArrayList<Object>();
        GwtAtmosphereResource resource = this.lookupResource(connectionID);
        if (resource == null) {
            return;
        }
        String mode = resource.getRequest().getParameter("sm");
        SerialMode serialMode = mode != null ? SerialMode.valueOf((String)mode) : SerialMode.RPC;
        try {
            String event;
            while ((event = data.readLine()) != null) {
                String action = data.readLine();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[" + connectionID + "] Server message received: " + event + ";" + action);
                }
                if (event.equals("o") || event.equals("s")) {
                    int length = Integer.parseInt(data.readLine());
                    char[] messageData = new char[length];
                    int totalRead = 0;
                    int read = 0;
                    while ((read = data.read(messageData, totalRead, length - totalRead)) != -1 && (totalRead += read) != length) {
                    }
                    if (totalRead != length) {
                        throw new IllegalStateException("Corrupt message received");
                    }
                    Object message = null;
                    if (event.equals("o")) {
                        try {
                            message = this.deserialize(messageData, serialMode);
                        }
                        catch (SerializationException ex) {
                            this.logger.error("Failed to deserialize message", (Throwable)ex);
                        }
                    } else {
                        message = String.copyValueOf(messageData);
                    }
                    if (message == null) continue;
                    if (action.equals("p")) {
                        postMessages.add(message);
                        continue;
                    }
                    if (!action.equals("b")) continue;
                    this.broadcast(message, resource);
                    continue;
                }
                if (!event.equals("c") || !action.equals("d")) continue;
                this.disconnect(resource);
            }
        }
        catch (IOException ex) {
            this.logger.error("[" + connectionID + "] Failed to read", (Throwable)ex);
        }
        if (postMessages.size() > 0) {
            this.post(request, response, postMessages, resource);
        }
    }

    protected Object deserialize(char[] data, SerialMode mode) throws SerializationException {
        return this.deserialize(String.copyValueOf(data), mode);
    }

    protected Object deserialize(String data, SerialMode mode) throws SerializationException {
        switch (mode) {
            default: {
                return this.getGwtRpc().deserialize(data);
            }
            case JSON: {
                return this.getJSONDeserializer().deserialize(data);
            }
            case PLAIN: 
        }
        return data;
    }

    protected GwtRpcDeserializer getGwtRpc() {
        if (this.gwtRpc == null) {
            this.gwtRpc = new GwtRpcDeserializer();
        }
        return this.gwtRpc;
    }

    protected JSONDeserializer getJSONDeserializer() {
        if (this.jsonSerializer == null) {
            ServiceLoader<JSONSerializerProvider> loader = ServiceLoader.load(JSONSerializerProvider.class, this.getClass().getClassLoader());
            if (loader != null && loader.iterator().hasNext()) {
                this.jsonSerializer = loader.iterator().next().getDeserializer();
            }
            if (this.jsonSerializer == null) {
                this.jsonSerializer = new JSONDeserializer(){

                    @Override
                    public Object deserialize(String data) {
                        return data;
                    }
                };
            }
        }
        return this.jsonSerializer;
    }

    public final void post(HttpServletRequest postRequest, HttpServletResponse postResponse, List<?> messages, GwtAtmosphereResource cometResource) {
        if (messages == null) {
            return;
        }
        this.doPost(postRequest, postResponse, messages, cometResource);
    }

    public void broadcast(Object message, GwtAtmosphereResource resource) {
        if (message == null) {
            return;
        }
        resource.getBroadcaster().broadcast(message);
    }

    public void broadcast(List<?> messages, GwtAtmosphereResource resource) {
        if (messages == null) {
            return;
        }
        resource.getBroadcaster().broadcast(messages);
    }

    public void disconnect(GwtAtmosphereResource resource) {
        if (resource != null) {
            this.logger.debug("Resuming connection[" + resource.getConnectionID() + "] after client disconnect message");
            resource.getAtmosphereResource().resume();
        }
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    protected int computeHeartbeat(int requestedHeartbeat) {
        return requestedHeartbeat < this.heartbeat ? this.heartbeat : requestedHeartbeat;
    }

    private void doCometImpl(GwtAtmosphereResourceImpl resource) throws IOException {
        int timeout;
        try {
            resource.getWriterImpl().initiate();
            if (this.resources == null) {
                this.resources = new ConcurrentHashMap<Integer, GwtAtmosphereResource>(5);
                this.scheduler.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        AtmosphereGwtHandler.this.reapResources();
                    }
                }, 30L, 10L, TimeUnit.SECONDS);
            }
            this.resources.put(resource.getConnectionID(), resource);
        }
        catch (IOException e) {
            this.logger.error("Error initiating GwtComet", (Throwable)e);
            return;
        }
        try {
            timeout = this.doComet(resource);
            if (timeout == -1) {
                this.logger.info("You have set an infinite timeout for your comet connection this is not recommended");
            }
        }
        catch (ServletException e) {
            this.logger.error("Error calling doComet()", (Throwable)e);
            return;
        }
        catch (IOException e) {
            this.logger.error("Error calling doComet()", (Throwable)e);
            return;
        }
        resource.suspend(timeout);
    }

    public void terminate(GwtAtmosphereResource cometResponse, boolean serverInitiated) {
        this.resources.remove(cometResponse.getConnectionID());
        this.cometTerminated(cometResponse, serverInitiated);
    }

    public String toString() {
        return "AtmosphereGwtAtmosphereHandler";
    }
}

