/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;

public class WebSocketProcessorFactory {
    private static WebSocketProcessorFactory factory;

    public static final synchronized WebSocketProcessorFactory getDefault() {
        if (factory == null) {
            factory = new WebSocketProcessorFactory();
        }
        return factory;
    }

    public WebSocketProcessor newWebSocketProcessor(WebSocket webSocket) {
        WebSocketProcessor wp = null;
        String webSocketProcessorName = webSocket.config().framework().getWebSocketProcessorClassName();
        if (!webSocketProcessorName.equalsIgnoreCase(DefaultWebSocketProcessor.class.getName())) {
            try {
                wp = (WebSocketProcessor)Thread.currentThread().getContextClassLoader().loadClass(webSocketProcessorName).newInstance();
            }
            catch (Exception ex) {
                try {
                    wp = (WebSocketProcessor)this.getClass().getClassLoader().loadClass(webSocketProcessorName).newInstance();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
        if (wp == null) {
            wp = new DefaultWebSocketProcessor(webSocket);
        }
        return wp;
    }
}

