/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.version.WebLogicWebSocket;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weblogic.websocket.ClosingMessage;
import weblogic.websocket.WSHandshakeRequest;
import weblogic.websocket.WSHandshakeResponse;
import weblogic.websocket.WebSocketConnection;
import weblogic.websocket.WebSocketContext;
import weblogic.websocket.WebSocketListener;
import weblogic.websocket.annotation.WebSocket;

@WebSocket(pathPatterns={"/ws/*"}, timeout=-1, maxMessageSize=8192)
public class WeblogicWebSocketHandler
implements WebSocketListener {
    private final Logger logger = LoggerFactory.getLogger(WeblogicWebSocketHandler.class);
    private WebSocketProcessor webSocketProcessor;
    private AtmosphereConfig config;
    private Integer maxTextBufferSize;
    private int webSocketWriteTimeout;
    private final ThreadLocal<WSHandshakeRequest> request = new ThreadLocal();

    public void init(WebSocketContext webSocketContext) {
        this.logger.info("WebSocketContext initialized {}", (Object)webSocketContext);
        this.configure(webSocketContext.getServletContext());
    }

    public void destroy() {
    }

    public boolean accept(WSHandshakeRequest wsHandshakeRequest, WSHandshakeResponse wsHandshakeResponse) {
        this.request.set(wsHandshakeRequest);
        return true;
    }

    public void onOpen(WebSocketConnection webSocketConnection) {
        if (this.webSocketWriteTimeout != -1) {
            webSocketConnection.getWebSocketContext().setTimeoutSecs(this.webSocketWriteTimeout);
        }
        if (this.maxTextBufferSize != -1) {
            webSocketConnection.getWebSocketContext().setMaxMessageSize(this.maxTextBufferSize.intValue());
        }
        WebLogicWebSocket webSocket = new WebLogicWebSocket(webSocketConnection, this.config);
        webSocketConnection.getWebSocketContext().getServletContext().setAttribute(webSocketConnection.toString(), (Object)webSocket);
        AtmosphereRequest ar = AtmosphereRequest.cloneRequest((HttpServletRequest)this.request.get(), true, false, true);
        this.request.set(null);
        try {
            this.webSocketProcessor.open(webSocket, ar, AtmosphereResponse.newInstance(this.config, ar, webSocket));
        }
        catch (IOException e) {
            this.logger.error("{}", (Throwable)e);
        }
    }

    public void onMessage(WebSocketConnection webSocketConnection, String s) {
        org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)webSocketConnection.getWebSocketContext().getServletContext().getAttribute(webSocketConnection.toString());
        this.webSocketProcessor.invokeWebSocketProtocol(webSocket, s);
    }

    public void onMessage(WebSocketConnection webSocketConnection, byte[] bytes) {
        org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)webSocketConnection.getWebSocketContext().getServletContext().getAttribute(webSocketConnection.toString());
        this.webSocketProcessor.invokeWebSocketProtocol(webSocket, bytes, 0, bytes.length);
    }

    public void onFragment(WebSocketConnection webSocketConnection, boolean b, String s) {
        this.logger.trace("Warning, Fragment not supported");
        this.onMessage(webSocketConnection, s);
    }

    public void onFragment(WebSocketConnection webSocketConnection, boolean b, byte[] bytes) {
        this.logger.trace("Warning, Fragment not supported");
        this.onMessage(webSocketConnection, bytes);
    }

    public void onPing(WebSocketConnection webSocketConnection, byte[] bytes) {
        this.logger.trace("Warning, Fragment not supported");
    }

    public void onPong(WebSocketConnection webSocketConnection, byte[] bytes) {
        this.logger.trace("Warning, Fragment not supported");
    }

    public void onTimeout(WebSocketConnection webSocketConnection) {
        org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)webSocketConnection.getWebSocketContext().getServletContext().getAttribute(webSocketConnection.toString());
        this.webSocketProcessor.close(webSocket, 1000);
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)webSocketConnection.getWebSocketContext().getServletContext().getAttribute(webSocketConnection.toString());
        webSocketConnection.getWebSocketContext().getServletContext().removeAttribute(webSocketConnection.toString());
        this.webSocketProcessor.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<Throwable>(throwable, WebSocketEventListener.WebSocketEvent.TYPE.EXCEPTION, webSocket));
    }

    public void onClose(WebSocketConnection webSocketConnection, ClosingMessage closingMessage) {
        org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)webSocketConnection.getWebSocketContext().getServletContext().getAttribute(webSocketConnection.toString());
        webSocketConnection.getWebSocketContext().getServletContext().removeAttribute(webSocketConnection.toString());
        this.webSocketProcessor.close(webSocket, closingMessage.getStatusCode());
    }

    private void configure(ServletContext servletContext) {
        this.config = (AtmosphereConfig)servletContext.getAttribute(AtmosphereConfig.class.getName());
        this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.config.framework());
        String s = this.config.getInitParameter("org.atmosphere.websocket.maxIdleTime");
        this.webSocketWriteTimeout = s != null ? Integer.valueOf(s) : -1;
        s = this.config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize");
        this.maxTextBufferSize = s != null ? Integer.valueOf(s) : Integer.valueOf(-1);
    }
}

