/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHandshakeFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHandshakeFilter.class);
    private String[] bannedVersion;

    public void init(FilterConfig filterConfig) throws ServletException {
        String draft = filterConfig.getInitParameter("org.atmosphere.websocket.bannedVersion");
        if (draft != null) {
            this.bannedVersion = draft.split(",");
            logger.debug("Blocked WebSocket Draft version {}", (Object)draft);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest r = (HttpServletRequest)request;
        if (Utils.webSocketEnabled(r)) {
            int draft = r.getIntHeader("Sec-WebSocket-Version");
            if (draft < 0) {
                draft = r.getIntHeader("Sec-WebSocket-Draft");
            }
            if (this.bannedVersion != null) {
                for (String s : this.bannedVersion) {
                    if (Integer.parseInt(s) != draft) continue;
                    logger.trace("Invalid WebSocket Specification {} with {} ", (Object)r.getHeader("Connection"), (Object)r.getIntHeader("Sec-WebSocket-Version"));
                    ((HttpServletResponse)response).addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                    ((HttpServletResponse)response).sendError(501, "Websocket protocol not supported");
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

