/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring;

import jakarta.servlet.ServletContext;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringWebObjectFactory
implements AtmosphereObjectFactory<Class<?>> {
    public static final String ATMOSPHERE_SPRING_EXCLUDE_CLASSES = "org.atmosphere.spring.excludedClasses";
    private static final Logger logger = LoggerFactory.getLogger(SpringWebObjectFactory.class);
    protected boolean preventSpringInjection = false;
    private final List<Class<?>> excludedFromInjection = new ArrayList();
    private AnnotationConfigApplicationContext context;

    public <T, U extends T> U newClassInstance(Class<T> classType, Class<U> classToInstantiate) throws InstantiationException, IllegalAccessException {
        Object t;
        if (this.preventSpringInjection && this.excludedFromInjection.contains(classType)) {
            logger.trace("Excluded from injection {}", (Object)classToInstantiate.getName());
            return classToInstantiate.newInstance();
        }
        String name = classToInstantiate.getSimpleName();
        if (!this.context.containsBeanDefinition(Introspector.decapitalize(name))) {
            this.context.register(new Class[]{classToInstantiate});
        }
        if ((t = this.context.getAutowireCapableBeanFactory().createBean(classToInstantiate)) == null) {
            logger.info("Unable to find {}. Creating the object directly.", (Object)classToInstantiate.getName());
            return classToInstantiate.newInstance();
        }
        return (U)t;
    }

    public AtmosphereObjectFactory allowInjectionOf(Class<?> aClass) {
        this.context.register(new Class[]{aClass});
        return this;
    }

    public String toString() {
        return "Spring Web ObjectFactory";
    }

    public void configure(AtmosphereConfig config) {
        try {
            String s = config.getInitParameter(ATMOSPHERE_SPRING_EXCLUDE_CLASSES);
            if (s != null) {
                String[] list;
                for (String clazz : list = s.split(",")) {
                    this.excludedFromInjection.add(IOUtils.loadClass(this.getClass(), (String)clazz));
                }
                if (list.length > 0) {
                    this.preventSpringInjection = true;
                }
            }
            this.context = new AnnotationConfigApplicationContext();
            this.context.setParent((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.framework().getServletContext()));
            this.context.refresh();
            this.context.register(new Class[]{AtmosphereConfig.class});
            String string = AtmosphereConfig.class.getSimpleName();
            String beanName = string.substring(0, 1).toLowerCase() + string.substring(1);
            ((AtmosphereConfig)this.context.getBean(beanName, new Object[]{config.framework()})).populate(config);
        }
        catch (Exception ex) {
            logger.warn("Unable to configure injection", (Throwable)ex);
        }
    }
}

