/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jboss.websockets.oio.internal;

import java.io.IOException;
import org.atmosphere.jboss.websockets.oio.ClosingStrategy;
import org.atmosphere.jboss.websockets.oio.HttpRequestBridge;
import org.atmosphere.jboss.websockets.oio.HttpResponseBridge;
import org.atmosphere.jboss.websockets.oio.OioWebSocket;

public abstract class Handshake {
    private final String version;
    private final String hashAlgorithm;
    private final String magicNumber;

    public Handshake(String version, String hashAlgorithm, String magicNumber) {
        this.version = version;
        this.hashAlgorithm = hashAlgorithm;
        this.magicNumber = magicNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getMagicNumber() {
        return this.magicNumber;
    }

    protected String getWebSocketLocation(HttpRequestBridge request) {
        return "ws://" + request.getHeader("Host") + request.getRequestURI();
    }

    public abstract OioWebSocket getWebSocket(HttpRequestBridge var1, HttpResponseBridge var2, ClosingStrategy var3) throws IOException;

    public abstract boolean matches(HttpRequestBridge var1);

    public abstract byte[] generateResponse(HttpRequestBridge var1, HttpResponseBridge var2) throws IOException;
}

