/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.ws;

import java.nio.ByteBuffer;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.Actions;
import org.atmosphere.vibe.platform.action.SimpleActions;
import org.atmosphere.vibe.platform.ws.ServerWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerWebSocket
implements ServerWebSocket {
    protected final Actions<String> textActions = new SimpleActions();
    protected final Actions<ByteBuffer> binaryActions = new SimpleActions();
    protected final Actions<Throwable> errorActions = new SimpleActions();
    protected final Actions<Void> closeActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    private final Logger logger = LoggerFactory.getLogger(AbstractServerWebSocket.class);
    private State state = State.OPEN;

    public AbstractServerWebSocket() {
        this.errorActions.add((Action)new Action<Throwable>(){

            public void on(Throwable throwable) {
                AbstractServerWebSocket.this.logger.trace("{} has received a throwable {}", (Object)AbstractServerWebSocket.this, (Object)throwable);
            }
        });
        this.closeActions.add((Action)new Action<Void>(){

            public void on(Void _) {
                AbstractServerWebSocket.this.state = State.CLOSED;
                AbstractServerWebSocket.this.logger.trace("{} has been closed", (Object)AbstractServerWebSocket.this);
            }
        });
    }

    @Override
    public void close() {
        this.logger.trace("{} has started to close the connection", (Object)this);
        if (this.state != State.CLOSING && this.state != State.CLOSED) {
            this.state = State.CLOSING;
            this.doClose();
        }
    }

    protected abstract void doClose();

    @Override
    public ServerWebSocket send(String data) {
        this.logger.trace("{} sends a text message {}", (Object)this, (Object)data);
        this.doSend(data);
        return this;
    }

    @Override
    public ServerWebSocket send(ByteBuffer byteBuffer) {
        if (this.logger.isTraceEnabled() && byteBuffer.hasArray()) {
            this.logger.trace("{} sends a text message {}", (Object)this, (Object)new String(byteBuffer.array()));
        }
        this.doSend(byteBuffer);
        return this;
    }

    protected abstract void doSend(ByteBuffer var1);

    protected abstract void doSend(String var1);

    @Override
    public ServerWebSocket textAction(Action<String> action) {
        this.textActions.add(action);
        return this;
    }

    @Override
    public ServerWebSocket binaryAction(Action<ByteBuffer> action) {
        this.binaryActions.add(action);
        return this;
    }

    @Override
    public ServerWebSocket closeAction(Action<Void> action) {
        this.closeActions.add(action);
        return this;
    }

    @Override
    public ServerWebSocket errorAction(Action<Throwable> action) {
        this.errorActions.add(action);
        return this;
    }

    private static enum State {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

