/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.config;

import com.google.common.collect.Iterables;
import com.sun.xml.bind.IDResolver;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.v2.model.runtime.RuntimeNonElement;
import com.sun.xml.bind.v2.runtime.IllegalAnnotationsException;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.atteo.evo.classindex.ClassIndex;
import org.atteo.evo.config.Configurable;
import org.atteo.evo.config.IncorrectConfigurationException;
import org.atteo.evo.config.XmlCombine;
import org.atteo.evo.config.XmlDefaultValue;
import org.atteo.evo.filtering.Filtering;
import org.atteo.evo.filtering.PropertiesPropertyResolver;
import org.atteo.evo.filtering.PropertyNotFoundException;
import org.atteo.evo.filtering.PropertyResolver;
import org.atteo.evo.jaxb.FilteringAnnotationReader;
import org.atteo.evo.jaxb.JaxbBindings;
import org.atteo.evo.jaxb.ScopedIdResolver;
import org.atteo.evo.xmlmerge.CombineChildren;
import org.atteo.evo.xmlmerge.CombineSelf;
import org.atteo.evo.xmlmerge.XmlCombiner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Configuration {
    private JAXBContext context;
    private Binder<Node> binder;
    private final Iterable<Class<? extends Configurable>> klasses;
    private DocumentBuilder builder;
    private Document document;
    private PropertyResolver propertyResolver;

    public Configuration() {
        this(ClassIndex.getSubclasses(Configurable.class));
    }

    public Configuration(Iterable<Class<? extends Configurable>> klasses) {
        this.klasses = klasses;
        this.propertyResolver = new PropertiesPropertyResolver(new Properties());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = factory.newDocumentBuilder();
            this.builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                }
            });
            this.context = JAXBContext.newInstance((Class[])((Class[])Iterables.toArray(klasses, Class.class)));
            this.binder = this.context.createBinder();
            this.binder.setProperty(IDResolver.class.getName(), (Object)new ScopedIdResolver());
            this.binder.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return true;
                }
            });
            this.document = this.builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Cannot configure XML parser", e);
        }
        catch (IllegalAnnotationsException e) {
            throw new RuntimeException("Cannot configure unmarshaller: " + e.toString());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Cannot configure unmarshaller", e);
        }
    }

    public void generateSchema(final File filename) throws IOException {
        this.context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                try {
                    SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
                    TransformerHandler transformer = factory.newTransformerHandler();
                    transformer.setResult(new StreamResult(new FileOutputStream(filename)));
                    SAXResult saxResult = new SAXResult(transformer);
                    saxResult.setSystemId("dummy");
                    return saxResult;
                }
                catch (TransformerConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void filter(Properties properties) throws IncorrectConfigurationException {
        this.filter(new PropertiesPropertyResolver(properties));
    }

    public void filter(PropertyResolver resolver) throws IncorrectConfigurationException {
        this.propertyResolver = resolver;
        if (this.document.getDocumentElement() == null) {
            return;
        }
        try {
            Filtering.filter(this.document.getDocumentElement(), resolver);
        }
        catch (PropertyNotFoundException e) {
            throw new IncorrectConfigurationException("Cannot resolve configuration properties: " + e.getMessage(), e);
        }
    }

    public void combine(InputStream stream) throws IncorrectConfigurationException, IOException {
        Document parentDocument = this.document;
        try {
            this.document = this.builder.parse(stream);
            Element root = parentDocument.getDocumentElement();
            if (root != null) {
                this.binder.unmarshal((Object)root);
                JaxbBindings.iterate(root, this.binder, new CombineAssigner());
                XmlCombiner combiner = new XmlCombiner(this.builder);
                combiner.combine(parentDocument);
                combiner.combine(this.document);
                this.document = combiner.buildDocument();
            }
        }
        catch (UnmarshalException e) {
            if (e.getLinkedException() != null) {
                throw new IncorrectConfigurationException("Cannot parse configuration file: " + e.getLinkedException().getMessage(), e.getLinkedException());
            }
            throw new RuntimeException("Cannot parse configuration file", e);
        }
        catch (JAXBException e) {
            throw new IncorrectConfigurationException("Unmarshall error: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new IncorrectConfigurationException("Parse error: " + e.getMessage(), e);
        }
    }

    public <T extends Configurable> T read(Class<T> rootClass) throws IncorrectConfigurationException {
        Configurable result;
        if (this.document.getDocumentElement() == null) {
            return null;
        }
        final StringBuilder errors = new StringBuilder();
        try {
            HashMap<String, FilteringAnnotationReader> map = new HashMap<String, FilteringAnnotationReader>();
            map.put(JAXBRIContext.ANNOTATION_READER, new FilteringAnnotationReader(this.propertyResolver));
            this.context = JAXBContext.newInstance((Class[])((Class[])Iterables.toArray(this.klasses, Class.class)), map);
            this.binder = this.context.createBinder();
            this.binder.setProperty(IDResolver.class.getName(), (Object)new ScopedIdResolver());
            this.binder.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    errors.append("\n  At line ").append(event.getLocator().getLineNumber()).append(": ").append(event.getMessage());
                    return false;
                }
            });
            result = (Configurable)rootClass.cast(this.binder.unmarshal((Object)this.document.getDocumentElement()));
            JaxbBindings.iterate(this.document.getDocumentElement(), this.binder, new DefaultsSetter(this.context, this.propertyResolver));
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            Validator validator = validatorFactory.getValidator();
            Set violations = validator.validate((Object)result, new Class[0]);
            if (!violations.isEmpty()) {
                for (ConstraintViolation violation : violations) {
                    errors.append("  Error at:   ").append(violation.getPropertyPath()).append("\n").append("    for value:   ").append(violation.getInvalidValue()).append("\n").append("    with message:    ").append(violation.getMessage());
                }
                throw new IncorrectConfigurationException("Constraints violation:" + errors.toString());
            }
        }
        catch (UnmarshalException e) {
            if (e.getLinkedException() != null) {
                throw new IncorrectConfigurationException("Parse error: " + e.getLinkedException().getMessage(), e.getLinkedException());
            }
            if (errors.length() > 0) {
                throw new IncorrectConfigurationException("Parse error: " + errors.toString(), e);
            }
            throw new IncorrectConfigurationException("Parse error:" + e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new IncorrectConfigurationException("Cannot unmarshall configuration file", e);
        }
        return (T)result;
    }

    public Element getRootElement() {
        return this.document.getDocumentElement();
    }

    public <T extends Configurable> T read(Class<T> rootClass, InputStream ... streams) throws IncorrectConfigurationException, IOException {
        for (InputStream stream : streams) {
            this.combine(stream);
        }
        return this.read(rootClass);
    }

    private static class DefaultsSetter
    implements JaxbBindings.Runnable {
        private JAXBRIContext context;
        private PropertyResolver properties;

        public DefaultsSetter(JAXBContext context, PropertyResolver properties) {
            this.context = (JAXBContextImpl)context;
            this.properties = properties;
        }

        @Override
        public void run(Element element, Object object, Field field) {
            for (Class<?> klass = object.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
                for (Field f : klass.getDeclaredFields()) {
                    Object v;
                    XmlDefaultValue defaultValue = f.getAnnotation(XmlDefaultValue.class);
                    if (defaultValue == null) continue;
                    if (f.getType().isPrimitive()) {
                        throw new RuntimeException("@XmlDefaultValue cannot be specified on primitive type: " + klass.getCanonicalName() + "." + f.getName());
                    }
                    boolean accessible = f.isAccessible();
                    f.setAccessible(true);
                    try {
                        if (f.get(object) != null) {
                            continue;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    String value = defaultValue.value();
                    try {
                        value = Filtering.filter(value, this.properties);
                    }
                    catch (PropertyNotFoundException e) {
                        if (field != null) {
                            throw new RuntimeException("Property not found for field '" + field.getName() + "'", e);
                        }
                        throw new RuntimeException("Property not found", e);
                    }
                    RuntimeNonElement typeInfo = this.context.getRuntimeTypeInfoSet().getTypeInfo(f.getType());
                    try {
                        v = typeInfo.getTransducer().parse((CharSequence)value);
                    }
                    catch (AccessorException | SAXException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        f.set(object, v);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    f.setAccessible(accessible);
                }
            }
        }
    }

    private static class CombineAssigner
    implements JaxbBindings.Runnable {
        private CombineAssigner() {
        }

        @Override
        public void run(Element element, Object object, Field field) {
            if (field != null) {
                this.setAttributesFromAnnotation(element, field.getAnnotation(XmlCombine.class));
            }
            if (object != null) {
                this.setAttributesFromAnnotation(element, object.getClass().getAnnotation(XmlCombine.class));
            }
        }

        private void setAttributesFromAnnotation(Element element, XmlCombine annotation) {
            if (annotation != null) {
                CombineChildren combineChildren;
                CombineSelf combineSelf;
                if (!element.hasAttribute("combine.self") && (combineSelf = annotation.self()) != null) {
                    element.setAttribute("combine.self", combineSelf.name());
                }
                if (!element.hasAttribute("combine.children") && (combineChildren = annotation.children()) != null) {
                    element.setAttribute("combine.children", combineChildren.name());
                }
            }
        }
    }
}

