/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.filtering;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.atteo.evo.filtering.PrefixedPropertyResolver;
import org.atteo.evo.filtering.PropertyNotFoundException;
import org.atteo.evo.filtering.PropertyResolver;

public class CompoundPropertyResolver
implements PropertyResolver {
    private List<PropertyResolver> resolvers = Lists.newArrayList();
    private Multimap<String, PrefixedPropertyResolver> prefixedResolvers = ArrayListMultimap.create();

    public CompoundPropertyResolver(PropertyResolver ... resolvers) {
        for (PropertyResolver resolver : resolvers) {
            this.addPropertyResolver(resolver);
        }
    }

    public final void addPropertyResolver(PropertyResolver resolver) {
        PrefixedPropertyResolver prefixedResolver;
        String prefix;
        if (resolver instanceof PrefixedPropertyResolver && (prefix = (prefixedResolver = (PrefixedPropertyResolver)resolver).getPrefix()) != null) {
            this.prefixedResolvers.put((Object)prefixedResolver.getPrefix(), (Object)prefixedResolver);
            return;
        }
        this.resolvers.add(resolver);
    }

    @Override
    public String resolveProperty(String name, PropertyResolver recurse) throws PropertyNotFoundException {
        for (Map.Entry entry : this.prefixedResolvers.asMap().entrySet()) {
            if (!name.startsWith((String)entry.getKey())) continue;
            for (PrefixedPropertyResolver resolver : (Collection)entry.getValue()) {
                String value = resolver.resolveProperty(name, recurse);
                if (value == null) continue;
                return value;
            }
            throw new PropertyNotFoundException(name);
        }
        for (PropertyResolver resolver : this.resolvers) {
            String value = resolver.resolveProperty(name, recurse);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

