/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.filtering;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.atteo.evo.filtering.CircularPropertyResolutionException;
import org.atteo.evo.filtering.PropertiesPropertyResolver;
import org.atteo.evo.filtering.PropertyNotFoundException;
import org.atteo.evo.filtering.PropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Filtering {
    private static final Logger logger = LoggerFactory.getLogger(Filtering.class);

    public static String getProperty(String value, PropertyResolver resolver) throws PropertyNotFoundException {
        if (resolver instanceof LoopCheckerResolver) {
            return resolver.resolveProperty(value, null);
        }
        return new LoopCheckerResolver(resolver).resolveProperty(value, resolver);
    }

    public static String filter(String value, PropertyResolver propertyResolver) throws PropertyNotFoundException {
        List<Token> parts = Filtering.splitIntoTokens(value);
        StringBuilder result = new StringBuilder();
        for (Token part : parts) {
            if (part.isProperty()) {
                String propertyValue = Filtering.getProperty(part.getValue(), propertyResolver);
                if (propertyValue == null) {
                    throw new PropertyNotFoundException(part.getValue());
                }
                result.append(propertyValue);
                continue;
            }
            result.append(part.getValue());
        }
        return result.toString();
    }

    public static List<Token> splitIntoTokens(String input) {
        int startPosition;
        ArrayList<Token> parts = new ArrayList<Token>();
        int index = 0;
        while ((startPosition = input.indexOf("${", index)) != -1) {
            int endposition;
            boolean lastDollar = false;
            int count = 1;
            int countBrace = 0;
            for (endposition = startPosition + 2; endposition < input.length(); ++endposition) {
                if (input.charAt(endposition) == '$') {
                    lastDollar = true;
                    continue;
                }
                if (input.charAt(endposition) == '{') {
                    if (lastDollar) {
                        ++count;
                    } else {
                        ++countBrace;
                    }
                } else if (input.charAt(endposition) == '}') {
                    if (countBrace > 0) {
                        --countBrace;
                    } else if (--count == 0) break;
                }
                lastDollar = false;
            }
            if (count > 0) break;
            if (index != startPosition) {
                parts.add(new Token(input.substring(index, startPosition), false));
            }
            String propertyName = input.substring(startPosition + 2, endposition);
            index = endposition + 1;
            parts.add(new Token(propertyName, true));
        }
        if (index != input.length()) {
            parts.add(new Token(input.substring(index), false));
        }
        return parts;
    }

    public static String filter(String value, Properties properties) throws PropertyNotFoundException {
        return Filtering.filter(value, (PropertyResolver)new PropertiesPropertyResolver(properties));
    }

    public static void filter(Element element, PropertyResolver propertyResolver) throws PropertyNotFoundException {
        XmlFiltering filtering = new XmlFiltering(propertyResolver);
        filtering.filterElement(element);
    }

    public static void filter(Element element, Properties properties) throws PropertyNotFoundException {
        Filtering.filter(element, (PropertyResolver)new PropertiesPropertyResolver(properties));
    }

    private static class XmlFiltering {
        private PropertyResolver propertyResolver;

        private XmlFiltering(PropertyResolver propertyResolver) {
            this.propertyResolver = propertyResolver;
        }

        private void filterElement(Element element) throws PropertyNotFoundException {
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node node = attributes.item(i);
                this.filterAttribute((Attr)node);
            }
            NodeList nodes = element.getChildNodes();
            block5: for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                switch (node.getNodeType()) {
                    case 1: {
                        this.filterElement((Element)node);
                        continue block5;
                    }
                    case 3: {
                        this.filterText((Text)node);
                    }
                }
            }
        }

        private void filterAttribute(Attr attribute) throws PropertyNotFoundException {
            attribute.setValue(this.filterString(attribute.getValue()));
        }

        private void filterText(Text text) throws PropertyNotFoundException {
            text.setTextContent(this.filterString(text.getTextContent()));
        }

        private String filterString(String value) throws PropertyNotFoundException {
            return Filtering.filter(value, this.propertyResolver);
        }
    }

    public static final class Token {
        private String value;
        private boolean property;

        public Token(String value, boolean property) {
            this.value = value;
            this.property = property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isProperty() {
            return this.property;
        }
    }

    private static final class LoopCheckerResolver
    implements PropertyResolver {
        private Set<String> inProgress = new HashSet<String>();
        private PropertyResolver resolver;

        private LoopCheckerResolver(PropertyResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public String resolveProperty(String name, PropertyResolver ignore) throws PropertyNotFoundException {
            if (this.inProgress.contains(name)) {
                throw new CircularPropertyResolutionException(name);
            }
            logger.debug("Resolving property: " + name);
            this.inProgress.add(name);
            String value = this.resolver.resolveProperty(name, this);
            this.inProgress.remove(name);
            return value;
        }
    }
}

