/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.filtering;

import com.google.common.base.Splitter;
import java.util.List;
import org.atteo.evo.filtering.Filtering;
import org.atteo.evo.filtering.PrefixedPropertyResolver;
import org.atteo.evo.filtering.PropertyNotFoundException;
import org.atteo.evo.filtering.PropertyResolver;

public class OneOfPropertyResolver
implements PrefixedPropertyResolver {
    private static final String prefix = "oneof:";

    @Override
    public String getPrefix() {
        return prefix;
    }

    @Override
    public String resolveProperty(String name, PropertyResolver resolver) throws PropertyNotFoundException {
        if (!name.startsWith(prefix)) {
            return null;
        }
        name = name.substring(prefix.length());
        List<Filtering.Token> tokens = Filtering.splitIntoTokens(name);
        StringBuilder result = new StringBuilder();
        boolean skip = false;
        for (Filtering.Token token : tokens) {
            if (token.isProperty()) {
                if (skip) continue;
                String value = Filtering.getProperty(token.getValue(), resolver);
                if (value == null) {
                    skip = true;
                }
                result.append(value);
                continue;
            }
            boolean first = true;
            for (String p : Splitter.on((char)',').split((CharSequence)token.getValue())) {
                if (!first) {
                    if (!skip) {
                        return result.toString();
                    }
                    result = new StringBuilder();
                    skip = false;
                }
                if (!skip) {
                    result.append(p);
                }
                if (!first) continue;
                first = false;
            }
        }
        if (skip) {
            return null;
        }
        return result.toString();
    }
}

